package com.pms.ocp.service;

import com.pms.ocp.model.dto.ModelSubscribeDTO;
import com.pms.ocp.model.entity.ModelSubscribe;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:07
 * @Description:模型订阅业务层接口
 */
public interface ModelSubscribeService {

    /**
     * 创建模型订阅
     *
     * @param modelSubscribeDTO
     * @return
     */
    Integer createModelIssue(ModelSubscribeDTO modelSubscribeDTO);

    /**
     * 删除模型订阅
     *
     * @param modelId
     * @return
     */
    Integer deleteModelIssue(String modelId);

    /**
     * 批量删除模型订阅
     *
     * @param ids
     * @return
     */
    Integer deleteBatchModelIssue(List<String> ids);

    /**
     * 更新模型订阅
     *
     * @param modelSubscribe
     * @return
     */
    Integer updateModelIssue(ModelSubscribe modelSubscribe);

    /**
     * 获取模型订阅
     *
     * @param
     * @return
     */
    List<ModelSubscribe> getModelIssueList(String objId, String modelCode, String subsCompanyCode);

    /**
     * 获取模型订阅列表
     *
     * @param modelId
     * @return
     */
    ModelSubscribeDTO getModelIssue(String modelId);
}
