package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.common.constants.CodeEnum;
import com.pms.ocp.common.utils.ExcelUtils;
import com.pms.ocp.mapper.ModelMapper;
import com.pms.ocp.model.dto.ModelDTO;
import com.pms.ocp.model.entity.Model;
import com.pms.ocp.model.entity.ModelProperty;
import com.pms.ocp.model.vo.ModelVO;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ModelService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:21
 * @Description:模型业务层实现
 */

@Service
public class ModelServiceImpl extends ServiceImpl<ModelMapper, Model> implements ModelService {

    @Autowired
    private ModelMapper modelMapper;

    /**
     * 创建模型
     *
     * @param modelDTO
     * @return
     */
    @Override
    public Integer createModel(ModelDTO modelDTO) {

        Model model = new Model();

        BeanUtils.copyProperties(modelDTO, model);

        model.setModelCtime(LocalDateTime.now());
        int result = modelMapper.insert(model);
        return result;
    }

    /**
     * 删除模型
     *
     * @param objId
     * @return
     */
    @Override
    public Integer deleteModel(String objId, String modelCode) {
        QueryWrapper<Model> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(Model::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(Model::getModelCode, modelCode);
        }

        return modelMapper.delete(queryWrapper);

    }

    /**
     * 更新模型
     *
     * @param modelDTO
     * @return
     */
    @Override
    public Integer updateModel(ModelDTO modelDTO) {
        Model model = new Model();

        BeanUtils.copyProperties(modelDTO, model);

        model.setModelMtime(LocalDateTime.now());

        UpdateWrapper<Model> updateWrapper = new UpdateWrapper<>();

        updateWrapper.lambda().eq(Model::getObjId, model.getObjId());

        return modelMapper.update(model, updateWrapper);
    }

    /**
     * 导入模型
     *
     * @param file
     * @return
     */
    @Override
    public Boolean importModel(MultipartFile file) throws IOException {

        //校验Excel文件
        ExcelUtils.checkFile(file);
        List<ModelVO> modelVOList = ExcelUtils.importExcel(file, ModelVO.class);
        List<Model> modelList = new ArrayList<>(modelVOList.size());

        if (!modelVOList.isEmpty()) {
            for (ModelVO modelVO : modelVOList) {
                Model model = new Model();
                BeanUtils.copyProperties(modelVO, model);
                model.setModelCtime(LocalDateTime.now());
                modelList.add(model);
            }
        }

        //校验Excel数据
//        checkData(excelCps);
        return modelMapper.insertBatchModel(modelList);

    }

    /**
     * 获取模型列表
     *
     * @param
     * @return
     */
    @Override
    public List<Model> getModelList(String objId, String modelCode) {
        QueryWrapper<Model> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(Model::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(Model::getModelCode, modelCode);
        }

        return modelMapper.selectList(queryWrapper);
    }

    /**
     * 获取模型
     *
     * @param objId
     * @return
     */
    @Override
    public Model getModel(String objId) {
        QueryWrapper<Model> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(Model::getObjId, objId);
        return modelMapper.selectOne(queryWrapper);
    }
}
