package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.pms.ocp.mapper.ModelSubscribeMapper;
import com.pms.ocp.model.dto.ModelSubscribeDTO;
import com.pms.ocp.model.entity.ModelSubscribe;
import com.pms.ocp.service.ModelSubscribeService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:22
 * @Description:模型订阅业务层实现
 */

@Service
public class ModelSubscribeServiceImpl implements ModelSubscribeService {

    @Autowired
    private ModelSubscribeMapper modelSubscribeMapper;

    @Override
    public Integer createModelIssue(ModelSubscribeDTO modelSubscribeDTO) {

        ModelSubscribe modelSubscribe = new ModelSubscribe();

        BeanUtils.copyProperties(modelSubscribeDTO, modelSubscribe);

        modelSubscribe.setSubsCtime(LocalDateTime.now());

        return modelSubscribeMapper.insert(modelSubscribe);
    }

    @Override
    public Integer deleteModelIssue(String modelId) {
        return null;
    }

    /**
     * 批量删除模型订阅
     *
     * @param ids
     * @return
     */
    @Override
    public Integer deleteBatchModelIssue(List<String> ids) {
        return modelSubscribeMapper.deleteBatchIds(ids);
    }

    @Override
    public Integer updateModelIssue(ModelSubscribe modelSubscribe) {
        return null;
    }

    @Override
    public List<ModelSubscribe> getModelIssueList(String objId, String modelCode, String subsCompanyCode) {
        QueryWrapper<ModelSubscribe> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(ModelSubscribe::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelSubscribe::getModelCode, modelCode);
        }

        if (StringUtils.isNotEmpty(subsCompanyCode)) {
            queryWrapper.lambda().eq(ModelSubscribe::getSubsCompanyCode, subsCompanyCode);
        }

        return modelSubscribeMapper.selectList(queryWrapper);
    }

    @Override
    public ModelSubscribeDTO getModelIssue(String modelId) {
        return null;
    }
}
