package com.pms.ocp.common.constants;

public class ServiceException extends RuntimeException {
	private static final long serialVersionUID = -6914996666319154848L;
    /**
     * 状态编码
     */
    public final int statusCode;
    /**
     * message信息
     */
    public final String msg;
    /**
     * 数据对象
     */
    public Object data;

    public ServiceException(String message, ResultCodee resultCode) {
        super(message);
        this.statusCode = resultCode.statusCode;
        this.msg = message;
    }

    public ServiceException(String message, ResultCodee resultCode, Object data) {
        this(message, resultCode);
        this.data = data;
    }

    public ServiceException(ResultCodee resultCode) {
        this(resultCode.msg, resultCode);
    }

    public ServiceException(ResultCodee resultCode, Object data) {
        this(resultCode.msg, resultCode, data);
    }
}
