package com.pms.ocp.common.utils;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * @author huxiuwu
 * @version 1.0
 * @date 2022/1/5 21:13
 */
public class ExcelUtils {

    /**
     * 导出excel通用方法
     *
     * @param response  响应对象
     * @param list      传入list
     * @param fileName  文件名称
     * @param sheetName sheet页名称
     * @param clazz     类对象
     * @return void
     * @author huxiuwu
     * @date 2022/1/5
     **/
//    public static void writeExcel(HttpServletResponse response, List<?> list, String fileName, String sheetName, Class clazz, HttpServletRequest request) {
//        try {
//            String characterEncoding = request.getCharacterEncoding();
//            //获取需要导出的数据
//            WriteCellStyle headWriteCellStyle = new WriteCellStyle();
//            //设置头居中
//            headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
//            //内容策略
//            WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
//            //设置 水平居中
//            contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
//            HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
//            response.setContentType("application/vnd.ms-excel;charset=" + characterEncoding);
//            response.setCharacterEncoding(characterEncoding);
//            // 这里URLEncoder.encode可以防止中文乱码 当然和easyExcel没有关系
//            String excelName = URLEncoder.encode(fileName, characterEncoding);
//            response.setHeader("Content-disposition", "attachment;filename=" + excelName + SymbolConstants.XLS_SUFFIX);
//            // 这里需要设置不关闭流
//            EasyExcel.write(response.getOutputStream(), clazz).
//                    autoCloseStream(Boolean.FALSE).
//                    registerWriteHandler(horizontalCellStyleStrategy).
//                    sheet(sheetName).doWrite(list);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//    }

    /**
     * Excel导出
     *
     * @param response  response
     * @param fileName  文件名
     * @param list      数据List
     * @param pojoClass 对象Class
     */
    public static void exportExcel(HttpServletResponse response, String fileName, Collection<?> list, Class<?> pojoClass) throws IOException {
        if (StringUtils.isBlank(fileName)) {
            //当前日期
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            fileName = df.format(new Date());

        }
        Workbook workbook = ExcelExportUtil.exportExcel(new ExportParams(fileName, fileName, ExcelType.XSSF), pojoClass, list);
        response.setCharacterEncoding("UTF-8");

        response.setHeader("content-Type", "application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8") + ".xls");
        ServletOutputStream out = response.getOutputStream();
        workbook.write(out);
        out.flush();
    }

    /**
     * Excel导出，先sourceList转换成List<targetClass>，再导出
     *
     * @param response    response
     * @param fileName    文件名
     * @param sourceList  原数据List
     * @param targetClass 目标对象Class
     */
    public static void exportExcelToTarget(HttpServletResponse response, String fileName, Collection<?> sourceList, Class<?> targetClass) throws Exception {
        List targetList = new ArrayList<>(sourceList.size());
        for (Object source : sourceList) {
            Object target = targetClass.newInstance();
            BeanUtils.copyProperties(source, target);
            targetList.add(target);
        }
        exportExcel(response, fileName, targetList, targetClass);
    }

    /**
     * Excel导出----设置title---sheetName---要求Collection<?> list是Class<?> pojoClass类型的
     *
     * @param response  response
     * @param fileName  文件名
     * @param list      数据List
     * @param pojoClass 对象Class
     */
    public static void exportExcel(HttpServletResponse response, String title, String sheetName, String fileName, Collection<?> list, Class<?> pojoClass) throws IOException {
        if (StringUtils.isBlank(fileName)) {
            //当前日期
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            fileName = df.format(new Date());
        }
        Workbook workbook = ExcelExportUtil.exportExcel(new ExportParams(title, sheetName, ExcelType.HSSF), pojoClass, list);
        response.setCharacterEncoding("UTF-8");
        response.setHeader("content-Type", "application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8") + ".xls");
        ServletOutputStream out = response.getOutputStream();
        workbook.write(out);
        out.flush();
    }

}
