package com.pms.ocp.controller;


import com.pms.ocp.model.dto.OcpTenantGroupDto;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.TenantService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Slf4j
@RequestMapping("/api-tenant/v1")
@RestController
@Api(tags = "应用树管理接口")
public class OcpTenantController {


    @Autowired
    private TenantService tenantService;
    /**
     * 应用树分类
     */

    @GetMapping("/tenanttree")
    @ApiModelProperty("应用树分类")
    private OcpTenantGroupDto getTenantTree(){
        OcpTenantGroupDto tree = tenantService.getTree();
        return tree;
    }

    @PostMapping("/tenantinster")
    @ApiModelProperty("新增应用")

    public ResponseVO tenantInster(@RequestBody OcpTenantGroup ocpTenantGroup){
      boolean falg =   tenantService.getTenanInster(ocpTenantGroup);
      if (falg){
          return ResponseVO.ok("新建成功！");
      }
      return ResponseVO.error("应用code已经存在！");

    }
}
