package com.pms.ocp.controller;

import com.pms.ocp.model.entity.OcpApiAudit;
import com.pms.ocp.model.entity.OcpTenantAudit;
import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.OcpApiAuditService;
import com.pms.ocp.service.OcpTenantAuditService;
import com.pms.ocp.service.OcpTenantBaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RequestMapping("/tenant")
@RestController
@Api(tags = "应用接口")
public class OcpTenantDetailsController {

    @Autowired
    private OcpTenantBaseService ocpTenantBaseService;

    @Autowired
    private OcpTenantAuditService ocpTenantAuditService;

    @ApiOperation("应用基础信息-查询")
    @PostMapping("/getotbList")
    public ResponseVO<List<OcpTenantBase>> getOtbList(@RequestBody OcpTenantBase ocpTenantBase){
        return ocpTenantBaseService.getOtbList(ocpTenantBase);
    }

    @ApiOperation("应用大事记-查询")
    @PostMapping("/getotaList")
    public ResponseVO<List<OcpApiAudit>> getOtaList(OcpTenantAudit ocpTenantAudit) {
        return ocpTenantAuditService.getOtaList(ocpTenantAudit);
    }

    @ApiOperation("应用大事记-查询详情")
    @PostMapping("/getotaListById")
    public ResponseVO<List<OcpApiAudit>> getOtaListById(@RequestBody OcpTenantAudit ocpTenantAudit) {
        return ocpTenantAuditService.getOtaListById(ocpTenantAudit);
    }
}
