package com.pms.ocp.controller;

import com.pms.ocp.model.dto.OcpApiBaseDto;
import com.pms.ocp.model.dto.OcpTenantBaseDto;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.TenantBasicManagementService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.sql.Timestamp;

@Slf4j
@RequestMapping("/tenant/basic")
@RestController
@Api(tags = "应用库服务基础管理接口")
public class TenantBasicManagementController {
    @Autowired
    private TenantBasicManagementService tenantBasicManagementService;
    @ApiOperation("条件查询")
    @GetMapping("/queryOcpTenantBaseDto")
    public ResponseVO queryOcpTenantBaseDto(
                                         @RequestParam(required = false) String keyword,
                                         @RequestParam(required = false) String tenantUnits,
                                         @RequestParam(required = false) Timestamp startTime,
                                         @RequestParam(required = false) Timestamp endTime,
                                         @RequestParam(required = false) int pageSize,
                                         @RequestParam(required = false) int pageNum
    ) {
        OcpTenantBaseDto ocpTenantBaseDto = tenantBasicManagementService.queryOcpTenantBaseDto( keyword, tenantUnits, startTime, endTime, pageSize
                , pageNum);
        return ResponseVO.ok(ocpTenantBaseDto);
    }
}
