package com.pms.ocp.model;

import lombok.ToString;

@ToString
public enum CommonCode implements ResultCode {

    SUCCESS(true,0,"操作成功!"),
    UNAUTHENTICATED(false,10001,"此操作需要登陆系统!"),
    UNAUTHORISE(false,10002,"权限不足，无权操作!"),
    INVALID_PARAM(false,10003,"非法参数!"),
    PAGE_PARAMS_MISS(false,10004, "分页参数缺失!"),
    RECORD_IS_NULL(false,10005, "数据不存在!"),
    PARAMS_MISS(false,10007, "参数缺失!"),
    FAIL(false,11111,"操作失败!"),
    CHECK_SUCCESS(true,10006,"校验成功!"),
    SERVER_ERROR(false,99999,"抱歉，系统繁忙，请稍后重试!"),
    //    private static ImmutableMap<Integer, CommonCode> codes;
    EXTIST(false,10007,"账号已存在!");

    //操作是否成功
    boolean success;

    //操作代码
    int code;

    //提示信息
    String message;

    CommonCode(boolean success, int code, String message){
        this.success = success;
        this.code = code;
        this.message = message;
    }

    @Override
    public boolean success() {
        return success;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String message() {
        return message;
    }

}
