package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import java.sql.Timestamp;

@Data
@Accessors(chain = true)

@ApiModel("服务应用关系表")
public class OcpApiTenantRel {

  @TableId(type = IdType.ASSIGN_ID)
  @ApiModelProperty("主键ID")
  private String objId;

  @ApiModelProperty("应用编码")
  private String tenantCode;

  @ApiModelProperty("服务编码")
  private String apiCode;

  @ApiModelProperty("服务部署公司")
  private String apiDepCompanyCode;

  @ApiModelProperty("应用所属公司")
  private String tenantDepCompanyCode;

  @ApiModelProperty("关系创建时间")
  private Timestamp apiTenantRelCtime;

  @ApiModelProperty("关系创建时间")
  private Timestamp apiTenantRelMtime;

  @ApiModelProperty("关系创建用户ID")
  private String apiTenantRelUserId;

  @ApiModelProperty("关系创建用户")
  private String apiTenantRelUserName;

  @ApiModelProperty("是否已删除0未删除，1已删除")
  private long isDelete;

  @ApiModelProperty("服务接口中文名称")
  private String apiName;

  @ApiModelProperty("服务分类代码")
  private String apiGroupCode;

  @ApiModelProperty("推广类型0:统建；1:自建")
  private long apiPromotion;

  @ApiModelProperty("服务请求体")
  private String apiReq;

  @ApiModelProperty("服务返回体")
  private String apiResp;

  @ApiModelProperty("服务地址")
  private String apiUrl;

  @ApiModelProperty("服务创建时间")
  private Timestamp apiCtime;

  @ApiModelProperty("服务修改时间")
  private Timestamp apiMtime;

  @ApiModelProperty("创建者用户ID")
  private String apiUserId;

  @ApiModelProperty("建设单位")
  private String apiUnit;

  @ApiModelProperty("服务所属公司")
  private String ownerCompanyCode;

  @ApiModelProperty("服务所属公司")
  private String ownerCompanyName;

  @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
  private long apiZone;

  @ApiModelProperty("'所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
  private long apiLayer;

  @ApiModelProperty("服务版本（最新版本）")
  private long apiVersion;

  @ApiModelProperty("应用名称")
  private String tenantName;

  @ApiModelProperty("应用分类代码")
  private String tenantGroupCode;

  @ApiModelProperty("应用IP")
  private String tenantIp;

  @ApiModelProperty("应用url")
  private String tenantUrl;

  @ApiModelProperty("所属专业")
  private String professionalKind;

  @ApiModelProperty("创建者用户ID")
  private String tenantUserId;

  @ApiModelProperty("排序")
  private String tenantOrderNo;

  @ApiModelProperty("创建时间")
  private String tenantCtime;

  @ApiModelProperty("最后更新时间")
  private String tenantMtime;

  @ApiModelProperty("部署名称")
  private String deploymentName;

  @ApiModelProperty("描述")
  private String tenantDescription;

  @ApiModelProperty("应用状态0设计 1运行态")
  private String tenantState;

  @ApiModelProperty("建设单位")
  private String tenantUnit;

  @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
  private String tenantZone;

  @ApiModelProperty("所属层级 1:应用层;2:平台层;3:网络层;4:感知层")
  private String tenantLayer;

  @ApiModelProperty("应用版本（当前版本）")
  private String tenantVersion;

  public String getObjId() {
    return objId;
  }

  public void setObjId(String objId) {
    this.objId = objId;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public String getApiCode() {
    return apiCode;
  }

  public void setApiCode(String apiCode) {
    this.apiCode = apiCode;
  }

  public String getApiDepCompanyCode() {
    return apiDepCompanyCode;
  }

  public void setApiDepCompanyCode(String apiDepCompanyCode) {
    this.apiDepCompanyCode = apiDepCompanyCode;
  }

  public String getTenantDepCompanyCode() {
    return tenantDepCompanyCode;
  }

  public void setTenantDepCompanyCode(String tenantDepCompanyCode) {
    this.tenantDepCompanyCode = tenantDepCompanyCode;
  }

  public Timestamp getApiTenantRelCtime() {
    return apiTenantRelCtime;
  }

  public void setApiTenantRelCtime(Timestamp apiTenantRelCtime) {
    this.apiTenantRelCtime = apiTenantRelCtime;
  }

  public Timestamp getApiTenantRelMtime() {
    return apiTenantRelMtime;
  }

  public void setApiTenantRelMtime(Timestamp apiTenantRelMtime) {
    this.apiTenantRelMtime = apiTenantRelMtime;
  }

  public String getApiTenantRelUserId() {
    return apiTenantRelUserId;
  }

  public void setApiTenantRelUserId(String apiTenantRelUserId) {
    this.apiTenantRelUserId = apiTenantRelUserId;
  }

  public String getApiTenantRelUserName() {
    return apiTenantRelUserName;
  }

  public void setApiTenantRelUserName(String apiTenantRelUserName) {
    this.apiTenantRelUserName = apiTenantRelUserName;
  }

  public long getIsDelete() {
    return isDelete;
  }

  public void setIsDelete(long isDelete) {
    this.isDelete = isDelete;
  }

  public String getApiName() {
    return apiName;
  }

  public void setApiName(String apiName) {
    this.apiName = apiName;
  }

  public String getApiGroupCode() {
    return apiGroupCode;
  }

  public void setApiGroupCode(String apiGroupCode) {
    this.apiGroupCode = apiGroupCode;
  }

  public long getApiPromotion() {
    return apiPromotion;
  }

  public void setApiPromotion(long apiPromotion) {
    this.apiPromotion = apiPromotion;
  }

  public String getApiReq() {
    return apiReq;
  }

  public void setApiReq(String apiReq) {
    this.apiReq = apiReq;
  }

  public String getApiResp() {
    return apiResp;
  }

  public void setApiResp(String apiResp) {
    this.apiResp = apiResp;
  }

  public String getApiUrl() {
    return apiUrl;
  }

  public void setApiUrl(String apiUrl) {
    this.apiUrl = apiUrl;
  }

  public Timestamp getApiCtime() {
    return apiCtime;
  }

  public void setApiCtime(Timestamp apiCtime) {
    this.apiCtime = apiCtime;
  }

  public Timestamp getApiMtime() {
    return apiMtime;
  }

  public void setApiMtime(Timestamp apiMtime) {
    this.apiMtime = apiMtime;
  }

  public String getApiUserId() {
    return apiUserId;
  }

  public void setApiUserId(String apiUserId) {
    this.apiUserId = apiUserId;
  }

  public String getApiUnit() {
    return apiUnit;
  }

  public void setApiUnit(String apiUnit) {
    this.apiUnit = apiUnit;
  }

  public String getOwnerCompanyCode() {
    return ownerCompanyCode;
  }

  public void setOwnerCompanyCode(String ownerCompanyCode) {
    this.ownerCompanyCode = ownerCompanyCode;
  }

  public String getOwnerCompanyName() {
    return ownerCompanyName;
  }

  public void setOwnerCompanyName(String ownerCompanyName) {
    this.ownerCompanyName = ownerCompanyName;
  }

  public long getApiZone() {
    return apiZone;
  }

  public void setApiZone(long apiZone) {
    this.apiZone = apiZone;
  }

  public long getApiLayer() {
    return apiLayer;
  }

  public void setApiLayer(long apiLayer) {
    this.apiLayer = apiLayer;
  }

  public long getApiVersion() {
    return apiVersion;
  }

  public void setApiVersion(long apiVersion) {
    this.apiVersion = apiVersion;
  }

  public String getTenantName() {
    return tenantName;
  }

  public void setTenantName(String tenantName) {
    this.tenantName = tenantName;
  }

  public String getTenantGroupCode() {
    return tenantGroupCode;
  }

  public void setTenantGroupCode(String tenantGroupCode) {
    this.tenantGroupCode = tenantGroupCode;
  }

  public String getTenantIp() {
    return tenantIp;
  }

  public void setTenantIp(String tenantIp) {
    this.tenantIp = tenantIp;
  }

  public String getTenantUrl() {
    return tenantUrl;
  }

  public void setTenantUrl(String tenantUrl) {
    this.tenantUrl = tenantUrl;
  }

  public String getProfessionalKind() {
    return professionalKind;
  }

  public void setProfessionalKind(String professionalKind) {
    this.professionalKind = professionalKind;
  }

  public String getTenantUserId() {
    return tenantUserId;
  }

  public void setTenantUserId(String tenantUserId) {
    this.tenantUserId = tenantUserId;
  }

  public String getTenantOrderNo() {
    return tenantOrderNo;
  }

  public void setTenantOrderNo(String tenantOrderNo) {
    this.tenantOrderNo = tenantOrderNo;
  }

  public String getTenantCtime() {
    return tenantCtime;
  }

  public void setTenantCtime(String tenantCtime) {
    this.tenantCtime = tenantCtime;
  }

  public String getTenantMtime() {
    return tenantMtime;
  }

  public void setTenantMtime(String tenantMtime) {
    this.tenantMtime = tenantMtime;
  }

  public String getDeploymentName() {
    return deploymentName;
  }

  public void setDeploymentName(String deploymentName) {
    this.deploymentName = deploymentName;
  }

  public String getTenantDescription() {
    return tenantDescription;
  }

  public void setTenantDescription(String tenantDescription) {
    this.tenantDescription = tenantDescription;
  }

  public String getTenantState() {
    return tenantState;
  }

  public void setTenantState(String tenantState) {
    this.tenantState = tenantState;
  }

  public String getTenantUnit() {
    return tenantUnit;
  }

  public void setTenantUnit(String tenantUnit) {
    this.tenantUnit = tenantUnit;
  }

  public String getTenantZone() {
    return tenantZone;
  }

  public void setTenantZone(String tenantZone) {
    this.tenantZone = tenantZone;
  }

  public String getTenantLayer() {
    return tenantLayer;
  }

  public void setTenantLayer(String tenantLayer) {
    this.tenantLayer = tenantLayer;
  }

  public String getTenantVersion() {
    return tenantVersion;
  }

  public void setTenantVersion(String tenantVersion) {
    this.tenantVersion = tenantVersion;
  }
}
