package com.pms.ocp.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.pms.ocp.model.dto.ApiBaseDto;
import com.pms.ocp.model.dto.OcpApiBaseDto;
import com.pms.ocp.model.entity.OcpApiBase;
import com.pms.ocp.model.entity.OcpApiExtent;
import com.pms.ocp.model.vo.OcpApiBaseVo;

import java.sql.Timestamp;
import java.util.List;

public interface ApiBasicManagementService extends IService<OcpApiBase> {
    /**
     * 导出的查询
     * @param apiCode
     * @return
     */
    List<OcpApiBaseVo> selectApiExport(String apiCodes);



    /**
     * 服务注册
     * @param ocpApiBase
     */
    void addOcpApiBase(OcpApiBase ocpApiBase);

    /**
     * 服务订阅
     * @param apiCodes
     */
    void apiLogin(String apiCodes);

    /**
     * 条件查询
     * @param apiCode
     * @param keyword
     * @param apiUnit
     * @param startTime
     * @param endTime
     * @return
     */
//    OcpApiBaseDto queryOcpApiBaseDto(ApiBaseDto apiBaseDto);
    List<OcpApiBaseVo> queryOcpApiBaseDto(String apiCode, String keyword, String apiUnits, Timestamp startTime, Timestamp endTime, int pageSize, int pageNum);
    /**
     * 导入的添加到数据库
     * @param personList
     */
    void apiImport(List<OcpApiBaseVo> personList);

    /**
     * 服务发布
     * @param apiCodes
     */
    void apiIssue(String apiCodes);


}
