package com.pms.ocp.service;

import com.pms.ocp.model.dto.ModelIssueDTO;
import com.pms.ocp.model.entity.ModelIssue;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:07
 * @Description:模型订阅业务层接口
 */
public interface ModelIssueService {

    /**
     * 创建模型订阅
     *
     * @param modelIssueDTO
     * @return
     */
    Integer createModelIssue(ModelIssueDTO modelIssueDTO);

    /**
     * 删除模型订阅
     *
     * @param modelId
     * @return
     */
    Integer deleteModelIssue(String modelId);

    /**
     * 批量删除模型订阅
     *
     * @param ids
     * @return
     */
    Integer deletePatchModelIssue(List<String> ids);

    /**
     * 更新模型订阅
     *
     * @param modelIssue
     * @return
     */
    Integer updateModelIssue(ModelIssue modelIssue);

    /**
     * 获取模型订阅
     *
     * @param
     * @return
     */
    List<ModelIssue> getModelIssueList(String objId, String modelCode, String subsCompanyCode);

    /**
     * 获取模型订阅列表
     *
     * @param modelId
     * @return
     */
    ModelIssueDTO getModelIssue(String modelId);
}
