package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.pms.ocp.mapper.ModelIssueMapper;
import com.pms.ocp.model.dto.ModelIssueDTO;
import com.pms.ocp.model.entity.ModelIssue;
import com.pms.ocp.service.ModelIssueService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:22
 * @Description:模型订阅业务层实现
 */

@Service
public class ModelIssueServiceImpl implements ModelIssueService {

    @Autowired
    private ModelIssueMapper modelIssueMapper;

    @Override
    public Integer createModelIssue(ModelIssueDTO modelIssueDTO) {

        ModelIssue modelIssue = new ModelIssue();

        BeanUtils.copyProperties(modelIssueDTO, modelIssue);

        modelIssue.setSubsCtime(LocalDateTime.now());

        return modelIssueMapper.insert(modelIssue);
    }

    @Override
    public Integer deleteModelIssue(String modelId) {
        return null;
    }

    /**
     * 批量删除模型订阅
     *
     * @param ids
     * @return
     */
    @Override
    public Integer deletePatchModelIssue(List<String> ids) {
        return modelIssueMapper.deleteBatchIds(ids);
    }

    @Override
    public Integer updateModelIssue(ModelIssue modelIssue) {
        return null;
    }

    @Override
    public List<ModelIssue> getModelIssueList(String objId, String modelCode, String subsCompanyCode) {
        QueryWrapper<ModelIssue> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(ModelIssue::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelIssue::getModelCode, modelCode);
        }

        if (StringUtils.isNotEmpty(subsCompanyCode)) {
            queryWrapper.lambda().eq(ModelIssue::getSubsCompanyCode, subsCompanyCode);
        }

        return modelIssueMapper.selectList(queryWrapper);
    }

    @Override
    public ModelIssueDTO getModelIssue(String modelId) {
        return null;
    }
}
