package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.pms.ocp.mapper.ModelPropertyMapper;
import com.pms.ocp.model.dto.ModelPropertyDTO;
import com.pms.ocp.model.entity.ModelProperty;
import com.pms.ocp.service.ModelPropertyService;
import io.swagger.models.auth.In;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Date;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:21
 * @Description:模型属性业务层实现
 */

@Service
public class ModelPropertyServiceImpl implements ModelPropertyService {

    @Autowired
    private ModelPropertyMapper modelPropertyMapper;

    @Override
    public Integer createModelProperty(ModelPropertyDTO modelPropertyDTO) {

        ModelProperty modelProperty = new ModelProperty();

        BeanUtils.copyProperties(modelPropertyDTO, modelProperty);

        modelProperty.setPropCtime(LocalDateTime.now());
        return modelPropertyMapper.insert(modelProperty);
    }

    @Override
    public Integer deleteModelProperty(String modelCode, String propCode) {
        QueryWrapper<ModelProperty> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelProperty::getModelCode, modelCode);
        }

        if (StringUtils.isNotEmpty(propCode)) {
            queryWrapper.lambda().eq(ModelProperty::getPropCode, propCode);
        }
        return modelPropertyMapper.delete(queryWrapper);
    }

    @Override
    public Integer deletePatchModelProperty(List<String> ids) {
        return modelPropertyMapper.deleteBatchIds(ids);
    }

    @Override
    public Integer updateModelProperty(ModelPropertyDTO modelPropertyDTO) {

        ModelProperty modelProperty = new ModelProperty();

        BeanUtils.copyProperties(modelPropertyDTO, modelProperty);

        modelProperty.setPropMtime(LocalDateTime.now());

        UpdateWrapper<ModelProperty> updateWrapper = new UpdateWrapper<>();

        updateWrapper.lambda().eq(ModelProperty::getObjId, modelProperty.getObjId());

        return modelPropertyMapper.update(modelProperty, updateWrapper);
    }

    @Override
    public List<ModelProperty> listModelProperty(String objId, String modelCode, String propCode) {

        QueryWrapper<ModelProperty> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(ModelProperty::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelProperty::getModelCode, modelCode);
        }

        if (StringUtils.isNotEmpty(propCode)) {
            queryWrapper.lambda().eq(ModelProperty::getPropCode, propCode);
        }

        return modelPropertyMapper.selectList(queryWrapper);
    }

    /**
     * TODO
     *
     * @return
     */
    @Override
    public ModelPropertyDTO getModelProperty() {
        QueryWrapper<ModelProperty> wrapper = new QueryWrapper<>();
        return null;
    }

}
