package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.pms.ocp.common.constants.CodeEnum;
import com.pms.ocp.mapper.ModelMapper;
import com.pms.ocp.model.entity.Model;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:21
 * @Description:模型业务层实现
 */

@Service
public class ModelServiceImpl implements ModelService {
    @Autowired
    private ModelMapper modelMapper;

    /**
     * 创建模型
     *
     * @param model
     * @return
     */
    @Override
    public ResponseVO createModel(Model model) {
        int result = modelMapper.insert(model);
        if (result > 0) {
            return ResponseVO.ok(CodeEnum.SUCCESS);
        } else {
            return ResponseVO.error(CodeEnum.INSERT_FAIL);
        }
    }

    /**
     * 删除模型
     *
     * @param modelId
     * @return
     */
    @Override
    public ResponseVO deleteModel(String modelId) {
        QueryWrapper<Model> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("obj_id", modelId);
        int result = modelMapper.delete(queryWrapper);
        if (result > 0) {
            return ResponseVO.ok(CodeEnum.SUCCESS);
        } else {
            return ResponseVO.error(CodeEnum.UNKNOWN);
        }
    }

    /**
     * 更新模型
     *
     * @param model
     * @return
     */
    @Override
    public ResponseVO updateModel(Model model) {
        int result = modelMapper.updateById(model);
        if (result > 0) {
            return ResponseVO.ok(CodeEnum.SUCCESS);
        } else {
            return ResponseVO.error(CodeEnum.UP_DATA_FAIL);
        }
    }

    /**
     * 获取模型列表
     *
     * @param
     * @return
     */
    @Override
    public ResponseVO getModelList() {
        List<Model> modelList = modelMapper.selectList(null);
        if (CollectionUtils.isEmpty(modelList)) {
            return ResponseVO.ok("查询列表为空");
        }
        return ResponseVO.ok(modelList);
    }

    /**
     * 获取模型
     *
     * @param modelId
     * @return
     */
    @Override
    public Model getModel(String modelId) {
        QueryWrapper<Model> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("model_id", modelId);
        return modelMapper.selectOne(queryWrapper);
    }
}
