package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.mapper.TenantBasicManagementMapper;
import com.pms.ocp.model.dto.OcpApiBaseDto;
import com.pms.ocp.model.dto.OcpTenantBaseDto;
import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.service.TenantBasicManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;

@Service
public class TenantBasicManagementServiceImpl extends ServiceImpl<TenantBasicManagementMapper, OcpTenantBase> implements TenantBasicManagementService {
    @Autowired
    private TenantBasicManagementMapper tenantBasicManagementMapper;
    /**
     * 应用条件查询
     * @param keyword
     * @param tenantUnits
     * @param startTime
     * @param endTime
     * @param pageSize
     * @param pageNum
     * @return
     */
    @Override
    public OcpTenantBaseDto queryOcpTenantBaseDto(String keyword, String tenantUnits, Timestamp startTime, Timestamp endTime, int pageSize, int pageNum) {
        String[] split = tenantUnits.split(",");
        List<String> list = Arrays.asList(split);
        pageSize = (pageSize - 1) * pageNum;
        OcpTenantBaseDto ocpTenantBaseDto = tenantBasicManagementMapper.queryOcpApiBaseDto(keyword, list, startTime, endTime,  pageSize, pageNum);
        return ocpTenantBaseDto;
    }
}
