package com.pms.ocp.service.impl;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.common.utils.RandomStringUtil;
import com.pms.ocp.mapper.TenantMapper;
import com.pms.ocp.model.dto.OcpTenantGroupDto;
import com.pms.ocp.model.dto.OneTenanList;
import com.pms.ocp.model.dto.ThreeTenanList;
import com.pms.ocp.model.dto.TwoTenanList;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.service.TenantService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class TenantServiceImpl extends ServiceImpl<TenantMapper, OcpTenantGroup> implements TenantService {


    @Autowired
    private TenantMapper tenantMapper;

    /**
     * 应用树分类管理
     *
     * @return
     */
    @Override
    public OcpTenantGroupDto getTree() {
        List<OcpTenantGroup> ocpTenantGroups = tenantMapper.selectList(null);

        //返回参数集合
        OcpTenantGroupDto ocpTenantGroupDto = new OcpTenantGroupDto();
        //顶级目录
        Set<String> stringSet = new HashSet<>();

        for (OcpTenantGroup ocpTenantGroup : ocpTenantGroups) {
            String tenantGroupCompanyCode = ocpTenantGroup.getTenantGroupCompanyCode();
            stringSet.add(tenantGroupCompanyCode);
        }

        List<TwoTenanList> tenanLists =  twoTenanTree(ocpTenantGroups,stringSet);
        List<ThreeTenanList> threeTenanLists = ThreeTenanTree(ocpTenantGroups,tenanLists);
        ocpTenantGroupDto.setOneList(stringSet);
        ocpTenantGroupDto.setTwoList(tenanLists);
        ocpTenantGroupDto.setThreeList(threeTenanLists);


        return ocpTenantGroupDto;
    }

    private List<ThreeTenanList> ThreeTenanTree(List<OcpTenantGroup> ocpTenantGroups, List<TwoTenanList> tenanLists) {
        //三级应用详情
        List<ThreeTenanList> threeTenanLists = new ArrayList<>();

        for (TwoTenanList tenanList : tenanLists) {
            for (OcpTenantGroup ocpTenantGroup : ocpTenantGroups) {
                ThreeTenanList threeTenanList = new ThreeTenanList();
                if (tenanList.getTenantGroupCode().equals(ocpTenantGroup.getTenantGroupPcode()) && ocpTenantGroup.getTenantGroupLevel() == 2){
                    BeanUtils.copyProperties(ocpTenantGroup,threeTenanList);
                    threeTenanLists.add(threeTenanList);
                }
            }
        }
        return threeTenanLists;
    }

    /**
     * 二级  应用管理
     * @param ocpTenantGroups
     * @param stringSet
     * @return
     */
    private List<TwoTenanList> twoTenanTree(List<OcpTenantGroup> ocpTenantGroups, Set<String> stringSet) {
        //一级数据集合
        List<TwoTenanList> twoTenanLists = new ArrayList<>();
        for (String code : stringSet) {
            for (OcpTenantGroup ocpTenantGroup : ocpTenantGroups) {
                TwoTenanList twoTenanList = new TwoTenanList();
                if (code.equals(ocpTenantGroup.getTenantGroupCompanyCode()) &&ocpTenantGroup.getTenantGroupLevel() == 1){
                    BeanUtils.copyProperties(ocpTenantGroup,twoTenanList);
                    twoTenanLists.add(twoTenanList);
                }
            }
        }
        return twoTenanLists;
    }


    /**
     * 应用新增
     *
     * @param ocpTenantGroup
     * @return
     */
    @Override
    public boolean getTenanInster(OcpTenantGroup ocpTenantGroup) {
        boolean falg = true;

        OcpTenantGroup group = new OcpTenantGroup();
        String tenantGroupCode = ocpTenantGroup.getTenantGroupCode();
        List<OcpTenantGroup> ocpTenantGroups = tenantMapper.selectList(null);
        for (OcpTenantGroup tenantGroup : ocpTenantGroups) {
            if (tenantGroup.getTenantGroupCode().equals(tenantGroupCode)){
                falg = false;
                break;
            }
        }
        group.setTenantGroupCode(RandomStringUtil.getRandomString(6));
        tenantMapper.insert(ocpTenantGroup);
        return falg;
    }

}
