package com.pms.ocp.common.aspectj;

import java.lang.annotation.*;

/**
 * @Auther: wangjian
 * @Date: 2022/3/8 17:17
 * @Description:
 */

@Target(ElementType.METHOD)  //target用于标识此注解能标记在方法上还是类上
@Retention(RetentionPolicy.RUNTIME) //retention用于决定此注解的生命周期
@Documented
public @interface OperLog {
    /**
     * 日志内容
     */
    String value() default "";

    /**
     * 日志类型(1登录日志，2操作日志)
     */
    int auditType() default 2;

    /**
     * 操作日志类型 1查询2添加3修改4删除
     */
    int operStatus() default 0;
}

