package com.pms.ocp.common.utils;

public class GUIDGenerator {
    private static final UUIDHexLengthGenerator GENERATOR = new UUIDHexLengthGenerator();

    public GUIDGenerator() {
    }

    private static String generate(int length, boolean toLowerCase) {
        setLength(length);
        return toLowerCase ? GENERATOR.generate().toString().toLowerCase() : GENERATOR.generate().toString().toUpperCase();
    }

    private static void setLength(int length) {
        GENERATOR.setLength(length);
    }

    public static String generate32(boolean toLowerCase) {
        return generate(32, toLowerCase);
    }

    public static String generate42(boolean toLowerCase) {
        return generate(42, toLowerCase);
    }
}
