package com.pms.ocp.controller;

import com.pms.ocp.common.config.CreateGroups;
import com.pms.ocp.common.utils.StringBusinessUtil;
import com.pms.ocp.model.dto.AppRegisterDTO;
import com.pms.ocp.model.dto.ImgDTO;
import com.pms.ocp.model.dto.QueryAppDTO;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.AppRegisterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 应用注册接口
 *
 * @author Administrator
 */
@RestController
@RequestMapping("appRegister")
@Api(tags = "应用注册接口")
public class AppRegisterController {

    @Autowired
    private AppRegisterService appRegisterService;

    @ApiOperation("新增应用注册")
    @PostMapping("addApp")
    public ResponseVO addApp(@RequestBody @Validated(CreateGroups.class) AppRegisterDTO appRegisterDTO,
                             BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return StringBusinessUtil.verifyDispose(bindingResult);
        }
        ResponseVO responseVO = appRegisterService.addApp(appRegisterDTO);
        return responseVO;
    }

    @ApiOperation("查询应用目录")
    @PostMapping("getAppInfo")
    public ResponseVO getAppInfo(@RequestBody @Validated QueryAppDTO queryAppDTO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return StringBusinessUtil.verifyDispose(bindingResult);
        }
        ResponseVO responseVO = appRegisterService.getAppInfo(queryAppDTO);
        return responseVO;
    }

    @ApiOperation("应用预览图")
    @PostMapping("addAppImgUrl")
    public ResponseVO addAppImgUrl(@RequestBody @Validated(CreateGroups.class) List<ImgDTO> imgDTO,
                                   BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return StringBusinessUtil.verifyDispose(bindingResult);
        }
        ResponseVO responseVO = appRegisterService.addAppImgUrl(imgDTO);
        return responseVO;
    }

}
