package com.pms.ocp.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.pms.ocp.model.dto.*;
import com.pms.ocp.model.entity.OcpApiGroup;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.TenantService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;


/**
 * @author zhaochengming
 */
@Slf4j
@RequestMapping("/api-tenant/v1")
@RestController
@Api(tags = "应用树管理接口")
public class OcpTenantController {


    @Autowired
    private TenantService tenantService;

    /**
     * 应用树分类
     * @return
     */
    @GetMapping("/tenantOnetree")
    @ApiModelProperty("应用树分类")
    private List<OcpTenantGroup> getTenantTree(OcpTenantGroup ocpTenantGroup) {
        List<OcpTenantGroup> tree= tenantService.getTree(ocpTenantGroup.getTenantGroupCompanyCode(),ocpTenantGroup.getTenantGroupCode(),ocpTenantGroup.getLevel());
        return tree;
    }
    @GetMapping("/tenantselect")
    @ApiModelProperty("应用树分类--查询")
    private ResponseVO<Page<OcpTenantGroup>> getselect(String tenantGroupCode,String tenantGroupCompanyCode,int currentPage,int pageSize,String keyword,String lev ){
        Page<OcpTenantGroup> tree= tenantService.getselects(tenantGroupCode,tenantGroupCompanyCode,currentPage,pageSize,keyword,lev);
        return ResponseVO.ok(tree);
    }

    @PostMapping("/tenantinster")
    @ApiModelProperty("新增应用")
    public ResponseVO tenantInster(@RequestBody TenanBaseDto tenanBaseDto){
        OcpTenantGroup tenanInster = tenantService.getTenanInster(tenanBaseDto);
        if ("1".equals(tenanInster.getNum())){
            return ResponseVO.error("1");
        }
          return ResponseVO.ok(tenanInster);

    }

    @PostMapping("/tenantupdata")
    @ApiModelProperty("修改应用")
    public ResponseVO tenantUpdata(@RequestBody OcpTenantGroup ocpTenantGroup){
        boolean falg =   tenantService.getTenantUpdata(ocpTenantGroup);
        if (falg){
            return ResponseVO.ok("修改成功！");
        }
        return ResponseVO.error("应用code已经存在！");
    }
    @PostMapping("/tenantdelete")
    @ApiModelProperty("删除服务")
    public ResponseVO tenantDelete(@RequestBody OcpTenantGroup ocpTenantGroup){
        boolean falg =   tenantService.gettenantDelete(ocpTenantGroup);
        if (falg){
            return ResponseVO.ok("删除成功！");
        }
        return ResponseVO.error("应用下存在服务，请先删除下级应该！");
    }







}
