package com.pms.ocp.model.dto;

import com.pms.ocp.model.entity.OcpTenantBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "应用信息图标储存表dto")
public class OcpBaseTiocnDto extends OcpTenantBase implements Serializable {

    /**
     * 图标种类tenant:应用图标api:服务图标
     */
    @ApiModelProperty(value = "图标种类——tenant:应用图标,api:服务图标")
    private String iocnType;

//    /**
//     * 编码值
//     */
//    @ApiModelProperty(value = "编码值")
//    private String codeNo;

    /**
     * 应用调用的服务数量图标数据
     */
    @ApiModelProperty(value = "应用调用的服务数量图标数据")
    private String iocn;

    @ApiModelProperty(value = "图片类型")
    private Object iocnKind;

    @ApiModelProperty(value = "服务编码字符串")
    private String apiCodes;

    public String getIocnType() {
        return iocnType;
    }

    public void setIocnType(String iocnType) {
        this.iocnType = iocnType;
    }

    public String getIocn() {
        return iocn;
    }

    public void setIocn(String iocn) {
        this.iocn = iocn;
    }

    public Object getIocnKind() {
        return iocnKind;
    }

    public void setIocnKind(Object iocnKind) {
        this.iocnKind = iocnKind;
    }

    public String getApiCodes() {
        return apiCodes;
    }

    public void setApiCodes(String apiCodes) {
        this.apiCodes = apiCodes;
    }
}
