package com.pms.ocp.model.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.sql.Timestamp;

@ApiModel(value = "我的应用-服务详情Dto")
@Data
public class OcpTenantGroupIocnDto {


    @ApiModelProperty("应用id")
    private String objId;

    @ApiModelProperty("应用名称")
    private String tenantName;

    /**
     * 应用代码
     */
    @ApiModelProperty("应用代码")
    private String tenantCode;

    /**
     * 应用分类代码
     */
    @ApiModelProperty("应用分类代码")
    private String tenantGroupCode;

    /**
     * 应用ip
     */
    @ApiModelProperty("应用ip")
    private String tenantIp;

    /**
     * 应用url
     */
    @ApiModelProperty("应用url")
    private String tenantUrl;

    /**
     * 所属专业
     */
    @ApiModelProperty("所属专业")
    private String professionalKind;

    /**
     * 创建者用户ID
     */
    @ApiModelProperty("创建者用户ID")
    private String tenantUserId;

    /**
     * 排序
     */
    @ApiModelProperty("排序")
    private Integer tenantOrderNo;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Timestamp tenantCtime;

    /**
     * 最后更新时间
     */
    @ApiModelProperty("最后更新时间")
    private Timestamp tenantMtime;

    /**
     * 部署名称
     */
//    @ApiModelProperty("部署名称")
//    private String deploymentName;

    /**
     * 描述
     */
    @ApiModelProperty("描述")
    private String tenantDescription;
//
//    /**
//     * 应用状态0:设计态；1:运行态
//     */
//    @ApiModelProperty("应用状态0:设计态；1:运行态")
//    private Short tenantState;
//    /**
//     * 推广类型0:统建；1:自建
//     */
//    @ApiModelProperty("推广类型0:统建；1:自建")
//    private long tenantPromotion;
    /**
     * 建设单位
     */
    @ApiModelProperty("建设单位")
    private String tenantUnit;

    /**
     * 所属公司编码
     */
    @ApiModelProperty("所属公司编码")
    private String ownerCompanyCode;

//    /**
//     * 所属公司名称
//     */
//    @ApiModelProperty("所属公司名称")
//    private String ownerCompanyName;

    /**
     * 是否删除0:否;1:是
     */
    @ApiModelProperty("是否删除0:否;1:是")
    private Short isDelete;

    /**
     * 所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区
     */
    @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
    private Short tenantZone;

    /**
     * 所属层级 1:应用层;2:平台层;3:网络层;4:感知层;
     */
    @ApiModelProperty("所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
    private Short tenantLayer;

    /**
     * 应用版本（当前版本）
     */
    @ApiModelProperty("应用版本（当前版本）")
    private String tenantVersion;


    @ApiModelProperty("推广类型")
    private Short tenantPromotion;


    @ApiModelProperty("应用路径")
    private String tenantFullPath;


    /**
     * 图标种类tenant:应用图标api:服务图标
     */
    @ApiModelProperty(value = "图标种类——tenant:应用图标,api:服务图标")
    private String iocnType;

    /**
     * 编码值
     */
    @ApiModelProperty(value = "编码值")
    private String codeNo;

    /**
     * 应用调用的服务数量图标数据
     */
    @ApiModelProperty(value = "应用调用的服务数量图标数据")
    private Object iocn;

    /**
     * 所属公司可能会根据公司分区
     */
    @ApiModelProperty(value = "所属公司可能会根据公司分区")
    private String companyCode;

    @ApiModelProperty("应用状态 '0: ''待审核'',1: ''已审核'',2: ''未通过'', 3: ''未提交'',4:''建设中'',5:''下架'',6:''发布'''")
    private Short tenantState;

    public Short getTenantState() {
        return tenantState;
    }

    public void setTenantState(Short tenantState) {
        this.tenantState = tenantState;
    }

    public String getIocnType() {
        return iocnType;
    }

    public void setIocnType(String iocnType) {
        this.iocnType = iocnType;
    }

    public String getCodeNo() {
        return codeNo;
    }

    public void setCodeNo(String codeNo) {
        this.codeNo = codeNo;
    }

    public Object getIocn() {
        return iocn;
    }

    public void setIocn(Object iocn) {
        this.iocn = iocn;
    }

    public String getObjId() {
        return objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getTenantGroupCode() {
        return tenantGroupCode;
    }

    public void setTenantGroupCode(String tenantGroupCode) {
        this.tenantGroupCode = tenantGroupCode;
    }

    public String getTenantIp() {
        return tenantIp;
    }

    public void setTenantIp(String tenantIp) {
        this.tenantIp = tenantIp;
    }

    public String getTenantUrl() {
        return tenantUrl;
    }

    public void setTenantUrl(String tenantUrl) {
        this.tenantUrl = tenantUrl;
    }

    public String getProfessionalKind() {
        return professionalKind;
    }

    public void setProfessionalKind(String professionalKind) {
        this.professionalKind = professionalKind;
    }

    public String getTenantUserId() {
        return tenantUserId;
    }

    public void setTenantUserId(String tenantUserId) {
        this.tenantUserId = tenantUserId;
    }

    public Integer getTenantOrderNo() {
        return tenantOrderNo;
    }

    public void setTenantOrderNo(Integer tenantOrderNo) {
        this.tenantOrderNo = tenantOrderNo;
    }

    public Timestamp getTenantCtime() {
        return tenantCtime;
    }

    public void setTenantCtime(Timestamp tenantCtime) {
        this.tenantCtime = tenantCtime;
    }

    public Timestamp getTenantMtime() {
        return tenantMtime;
    }

    public void setTenantMtime(Timestamp tenantMtime) {
        this.tenantMtime = tenantMtime;
    }

    public String getTenantDescription() {
        return tenantDescription;
    }

    public void setTenantDescription(String tenantDescription) {
        this.tenantDescription = tenantDescription;
    }

    public String getTenantUnit() {
        return tenantUnit;
    }

    public void setTenantUnit(String tenantUnit) {
        this.tenantUnit = tenantUnit;
    }

    public String getOwnerCompanyCode() {
        return ownerCompanyCode;
    }

    public void setOwnerCompanyCode(String ownerCompanyCode) {
        this.ownerCompanyCode = ownerCompanyCode;
    }

    public Short getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Short isDelete) {
        this.isDelete = isDelete;
    }

    public Short getTenantZone() {
        return tenantZone;
    }

    public void setTenantZone(Short tenantZone) {
        this.tenantZone = tenantZone;
    }

    public Short getTenantLayer() {
        return tenantLayer;
    }

    public void setTenantLayer(Short tenantLayer) {
        this.tenantLayer = tenantLayer;
    }

    public String getTenantVersion() {
        return tenantVersion;
    }

    public void setTenantVersion(String tenantVersion) {
        this.tenantVersion = tenantVersion;
    }

    public Short getTenantPromotion() {
        return tenantPromotion;
    }

    public void setTenantPromotion(Short tenantPromotion) {
        this.tenantPromotion = tenantPromotion;
    }

    public String getTenantFullPath() {
        return tenantFullPath;
    }

    public void setTenantFullPath(String tenantFullPath) {
        this.tenantFullPath = tenantFullPath;
    }


    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }
}
