package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/3/10 19:16
 * @Description:模型关系对象
 */

@Data
@Accessors(chain = true)
@TableName("ocp_model_rel")
public class ModelRelation {

    /**
     * 模型关系编号
     * 主键
     */
    @TableId(value = "obj_id", type = IdType.ASSIGN_ID)
    private String objId;

    /**
     * 模型编码
     */
    private String modelCode;

    /**
     * 模型属性编码
     */
    private String modelPropCode;

    /**
     * 关联模型编码
     */
    private String relationModeCode;

    /**
     * 关联模型属性编码
     */
    private String relationModePropCode;

    /**
     * 提交人编号
     */
    private String modelUserId;


    /**
     * 提交人姓名
     */
    private String modelUserName;

    /**
     * 订阅时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modelCtime;

    /**
     * 修改时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modelMtime;

    /**
     * 是否已删除 0:未删除 1:已删除
     */
    @TableField("is_delete")
    private String boolDelete;

}


//    create table ocp_model_rel
//        (
//                obj_id                  varchar(42)  constraint ocp_model_rel_pkey primary key,
//        model_code              varchar(42)  default ''::character varying not null,
//        model_prop_code         varchar(42)  default ''::character varying not null,
//        relation_mode_code      varchar(42)  default ''::character varying not null,
//        relation_mode_prop_code varchar(43)  default ''::character varying not null,
//        model_user_id           varchar(42)  default ''::character varying,
//        model_user_name         varchar(64)  default ''::character varying,
//        model_ctime             timestamp(6) default '2000-01-01 00:00:00'::timestamp(0) without time zone,
//        model_mtime             timestamp(6) default '2000-01-01 00:00:00'::timestamp(0) without time zone,
//        is_delete               smallint     default '-1'::integer
//        );
//
//        comment on table ocp_model_rel is '模型关系表';
//        comment on column ocp_model_rel.obj_id is '主键';
//        comment on column ocp_model_rel.model_code is '模型编码';
//        comment on column ocp_model_rel.model_prop_code is '模型属性编码';
//        comment on column ocp_model_rel.relation_mode_code is '关联模型编码';
//        comment on column ocp_model_rel.relation_mode_prop_code is '关联模型属性编码';
//        comment on column ocp_model_rel.model_user_id is '提交人id';
//        comment on column ocp_model_rel.model_user_name is '提交人姓名';
//        comment on column ocp_model_rel.model_ctime is '创建时间';
//        comment on column ocp_model_rel.model_mtime is '修改时间';
//        comment on column ocp_model_rel.is_delete is '是否已删除0:未删除 1:已删除';