package com.pms.ocp.model.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * 应用事记表
 * @TableName ocp_tenant_audit
 */
@Data
@Accessors(chain = true)
@ApiModel("应用事记表1")
public class OcpTenantAudit implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    @Excel(name = "主键ID",orderNum = "1")
    private String objId;

    /**
     * 应用code
     */
    @ApiModelProperty("应用code")
    @Excel(name = "应用code",orderNum = "2")
    private String tenantCode;

    /**
     * 操作状态0:新增,1:迭代；2，下线
     */
    @ApiModelProperty("操作状态0:新增,1:迭代；2，下线")
    @Excel(name = "操作状态0:新增,1:迭代；2，下线",orderNum = "3")
    private Short operStatus;

    /**
     * 类型0:人工操作,1:流程管控,3:总部下发
     */
    @ApiModelProperty("类型0:人工操作,1:流程管控,3:总部下发")
    @Excel(name = "类型0:人工操作,1:流程管控,3:总部下发",orderNum = "4")
    private Short auditType;

    /**
     * 备注简述
     */
    @ApiModelProperty("备注简述")
    @Excel(name = "备注简述",orderNum = "5")
    private String auditMessage;

    /**
     * 应用事记内容
     */
    @ApiModelProperty("应用事记内容")
    @Excel(name = "应用事记内容",orderNum = "6")
    private String auditJson;

    /**
     * 提交人id
     */
    @ApiModelProperty("提交人id")
    @Excel(name = "提交人id",orderNum = "7")
    private String auditUserId;

    /**
     * 提交人姓名
     */
    @ApiModelProperty("提交人姓名")
    @Excel(name = "提交人姓名",orderNum = "8")
    private String auditUserName;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    @Excel(name = "创建时间",orderNum = "9")
    private Timestamp auditCtime;

    /**
     * 应用版本(当前版本)
     */
    @ApiModelProperty(" 应用版本(当前版本")
    @Excel(name = " 应用版本(当前版本",orderNum = "10")
    private String applyVersion;

    /**
     * 上一版本
     */
    @ApiModelProperty("上一版本")
    @Excel(name = " 上一版本",orderNum = "11")
    private String perTenantVersion;

    public String getObjId() {
        return objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public Short getOperStatus() {
        return operStatus;
    }

    public void setOperStatus(Short operStatus) {
        this.operStatus = operStatus;
    }

    public Short getAuditType() {
        return auditType;
    }

    public void setAuditType(Short auditType) {
        this.auditType = auditType;
    }

    public String getAuditMessage() {
        return auditMessage;
    }

    public void setAuditMessage(String auditMessage) {
        this.auditMessage = auditMessage;
    }

    public String getAuditJson() {
        return auditJson;
    }

    public void setAuditJson(String auditJson) {
        this.auditJson = auditJson;
    }

    public String getAuditUserId() {
        return auditUserId;
    }

    public void setAuditUserId(String auditUserId) {
        this.auditUserId = auditUserId;
    }

    public String getAuditUserName() {
        return auditUserName;
    }

    public void setAuditUserName(String auditUserName) {
        this.auditUserName = auditUserName;
    }

    public Timestamp getAuditCtime() {
        return auditCtime;
    }

    public void setAuditCtime(Timestamp auditCtime) {
        this.auditCtime = auditCtime;
    }

    public String getApplyVersion() {
        return applyVersion;
    }

    public void setApplyVersion(String applyVersion) {
        this.applyVersion = applyVersion;
    }

    public String getPerTenantVersion() {
        return perTenantVersion;
    }

    public void setPerTenantVersion(String perTenantVersion) {
        this.perTenantVersion = perTenantVersion;
    }
}