package com.pms.ocp.model.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.sql.Timestamp;

/**
* @className: ApiManagementVO
* @Description:
* @author: pei-chen-xi
* @DateTime: 2022/3/25 15:03
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "服务管理vo")
public class ApiManagementVO implements Serializable {
    @ApiModelProperty(value = "序号")
    @Excel(name = "序号")
    private String objId;
    @ApiModelProperty(value = "服务名称")
    @Excel(name = "服务名称")
    private String apiName;
    @ApiModelProperty(value = "服务类型")
    @Excel(name = "服务类型")
    private String apiGroupCode;
    @ApiModelProperty("服务编码")
    @Excel(name = "服务编码")
    private String apiCode;
    @ApiModelProperty(value = "服务简述")
    @Excel(name = "服务简述")
    private String apiDescription;
    @ApiModelProperty(value = "服务所属公司")
    @Excel(name = "服务所属公司")
    private String ownerCompanyCode;
    @ApiModelProperty(value = "服务版本")
    @Excel(name = "服务版本")
    private String apiVersion;
    @ApiModelProperty(value = "接口地址")
    @Excel(name = "接口地址")
    private String apiUrl;
    @ApiModelProperty(value = "更新时间")
    @Excel(name = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Timestamp apiCtime;
//    @ApiModelProperty(value = "数据格式")
//    @Excel(name = "数据格式")
//    private String apiName;
//    @ApiModelProperty(value = "请求方式")
//    @Excel(name = "请求方式")
//    private String spaceName;
//    @ApiModelProperty(value = "调用次数")
//    @Excel(name = "调用次数")
//    private String apiUrl;
//    @ApiModelProperty(value = "更新人员")
//    @Excel(name = "更新人员")
//    private String apiUserName;
}
