package com.pms.ocp.model.vo;

import com.pms.ocp.common.constants.CodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author wuwanli
 * @version 1.0
 * @date 2021/8/5
 */
@Data
@ToString
@ApiModel(value = "BaseResponse返回对象", description = "BaseResponse返回对象")
public class BaseResponse implements Serializable {
    private static final long serialVersionUID = -3715259891657893705L;
    /**
     * 返回码
     */
    @ApiModelProperty(value = "返回码")
    private String code;
    /**
     * 返回描述
     */
    @ApiModelProperty(value = "返回描述")
    private String desc;
    @ApiModelProperty(value = "是否成功")
    private boolean success;

    public BaseResponse() {
        super();
    }

    public BaseResponse(CodeEnum codeEnum) {
        this.code = codeEnum.getCode();
        this.desc = codeEnum.getDesc();
        this.success = codeEnum.isSuccess();
    }

    public void setResponseCode(CodeEnum codeEnum) {
        this.code = codeEnum.getCode();
        this.desc = codeEnum.getDesc();
        this.success = codeEnum.isSuccess();
    }
}
