package com.pms.ocp.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.pms.ocp.model.QueryResponseResult;
import com.pms.ocp.model.dto.*;
import com.pms.ocp.model.entity.OcpApiBase;
import com.pms.ocp.model.entity.OcpApiExtent;
import com.pms.ocp.model.entity.OcpApiGroup;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.model.vo.OcpApiBaseVo;
import com.pms.ocp.model.vo.ResponseVO;

import java.sql.Timestamp;
import java.util.List;
/**
 * @author guofanfan
 */
public interface ApiBasicManagementService extends IService<OcpApiBase> {
    /**
     * 导出的查询
     * @param apiCodes
     * @return
     */
    List<OcpApiBaseVo> selectApiExport(String apiCodes);



    /**
     * 服务注册
     * @param ocpApiBase
     */
    void addOcpApiBase(OcpApiBase ocpApiBase);

    /**
     * 服务订阅
     * @param apiCodes
     */
    void apiLogin(String apiCodes);


    /**
     * 导入的添加到数据库
     * @param personList
     */
    void apiImport(List<OcpApiBaseVo> personList);

    /**
     * 服务发布
     * @param apiCodes
     */
    ResponseVO apiIssue(String apiCodes);

    /**
     *  获取顶级服务树
     * @param apiGroupCompanyCode
     * @return
     */
    List<OcpApiGroup> apiBaseTree(String apiGroupCompanyCode);

    /**
     *  获取次级服务树
     * @param apiGroupCompanyCode
     * @param apiGroupPcode
     * @return
     */
    List<OcpGroupBaseDto> apiBaseTreeOther(String apiGroupCompanyCode, String apiGroupPcode, Integer apiGroupPromotionType, String apiCode);

    /**
     * 根据分组code获取列表
     * @param ApiBaseReq
     * @return
     */
    ResponseVO<PageInfo<OcpApiBaseVo>> getBaseByGroupCode(ApiBaseDto ApiBaseReq);

    /**
     *   服务分类暴露服务列表
     * @param apiGroupCompanyCode
     * @param apiGroupPcode
     * @return
     */
    List<OcpApiBase> apiBaseTreeApiList(String apiGroupCompanyCode, String apiGroupPcode);

    /**
     * 省侧-应用接入申请-的模糊查询
     * @param apiCode
     * @param apiName
     * @param apiCenterCode
     * @param pageNum
     * @param pageSize
     * @param apiGroupCode
     * @return
     */
    ResponseVO<PageInfo<OcpApiBase>> selectByCondition(String apiCode, String apiName, String apiCenterCode,Integer pageNum,Integer pageSize,String apiGroupCode);

    /**
     * 省侧-应用接入申请-查询组中所有中心
     * @return
     */
    ResponseVO<List<OcpApiGroup>> selectCentre();

//    /**
//     * 服务列表2
//     * @param wholeLinkParamDto
//     * @return
//     */
//    ResponseVO queryApiTreeData(WholeLinkParamDto wholeLinkParamDto);
}
