package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.mapper.OcpTenantBaseMapper;
import com.pms.ocp.mapper.OcpTenantIocnMapper;
import com.pms.ocp.model.dto.OcpTenantDto;
import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.model.entity.OcpTenantIocn;
import com.pms.ocp.service.OcpTenantBaseService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class OcpTenantBaseServiceImpl extends ServiceImpl<OcpTenantBaseMapper, OcpTenantBase> implements OcpTenantBaseService {

    @Autowired
    private OcpTenantBaseMapper ocpTenantBaseMapper;

    @Autowired
    private OcpTenantIocnMapper ocpTenantIocnMapper;


    /**
     * 我的应用 -- 应用删除
     *
     * @param objId
     * @return
     */
    @Override
    public boolean delectApply(String objId) {


        if (StringUtils.isNotBlank(objId)) {
            return false;
        }
        OcpTenantBase ocpTenantBase = ocpTenantBaseMapper.selectById(objId);
        ocpTenantBase.setIsDelete((short) 1);
        ocpTenantBaseMapper.updateById(ocpTenantBase);

        return true;
    }

    /**
     * 我的应用--应用详情
     *
     * @param objId
     * @return
     */
    @Override
    public OcpTenantDto selectDetails(String objId) {

        OcpTenantDto ocpTenantDto = new OcpTenantDto();
        OcpTenantBase ocpTenantBase = ocpTenantBaseMapper.selectById(objId);
        BeanUtils.copyProperties(ocpTenantBase,ocpTenantDto);
        String tenantCode = ocpTenantBase.getTenantCode();

        if (StringUtils.isBlank(tenantCode)){
            OcpTenantIocn ocpTenantIocn = ocpTenantIocnMapper.selectCode(tenantCode);
            BeanUtils.copyProperties(ocpTenantIocn,ocpTenantDto);
        }

        return ocpTenantDto;
    }
}
