package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.pms.ocp.common.constants.Constant;
import com.pms.ocp.common.utils.GUIDGenerator;
import com.pms.ocp.mapper.OcpApiBaseMapper;
import com.pms.ocp.mapper.OcpApiGroupMapper;
import com.pms.ocp.mapper.PmsApiManagementMapper;
import com.pms.ocp.mapper.PmsApiModelRelMapper;
import com.pms.ocp.model.CommonCode;
import com.pms.ocp.model.ResponseResult;
import com.pms.ocp.model.entity.*;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.PmsApiManagementService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class PmsApiManagementServiceImpl extends ServiceImpl<PmsApiManagementMapper, PmsApiManagement> implements PmsApiManagementService {

    @Autowired
    private PmsApiManagementMapper pmsApiManagementMapper;

    @Autowired
    private OcpApiBaseMapper ocpApiBaseMapper;

    @Autowired
    private OcpApiGroupMapper ocpApiGroupMapper;

    @Autowired
    private PmsApiModelRelMapper pmsApiModelRelMapper;



    @Override
    public ResponseVO<PageInfo<PmsApiManagement>> getPammList(PmsApiManagement pmsApiManagement) {
        if (pmsApiManagement.getCurrentPage() ==null || pmsApiManagement.getPageSize() == null) {
            return ResponseVO.error("分页参数不能为空");
        }
        PageHelper.startPage(pmsApiManagement.getCurrentPage(),pmsApiManagement.getPageSize());
        List<PmsApiManagement> pammList = pmsApiManagementMapper.getPammList(pmsApiManagement);
        PageInfo<PmsApiManagement> pageInfo = new PageInfo<>(pammList);
        return ResponseVO.ok(pageInfo);
    }

    @Override
    public ResponseVO getPammByCode(PmsApiManagement pmsApiManagement) {
        List<PmsApiManagement> pammByCode = pmsApiManagementMapper.getPammByCode(pmsApiManagement);
        return ResponseVO.ok(pammByCode);
    }



    @Override
    public PmsApiMangageApi add(PmsApiMangageApi pmsApiMangageApi) {
        pmsApiMangageApi.setObjId(GUIDGenerator.generate32(true));
        pmsApiManagementMapper.addPamm(pmsApiMangageApi);
        pmsApiMangageApi.setApiCode(pmsApiMangageApi.getApiGroupName());
        pmsApiManagementMapper.addOag(pmsApiMangageApi);
        return pmsApiMangageApi;
    }

    @Override
    public ResponseResult deleteApi(PmsApiMangageApi pmsApiMangageApi) {
        //服务模型
        OcpApiModelRel oamr = new OcpApiModelRel();
        oamr.setApiCode(pmsApiMangageApi.getApiCode());
        List<OcpApiModelRel> apiModel = pmsApiManagementMapper.getApiModel(oamr);

        //应用服务
        OcpApiTenantRel oat = new OcpApiTenantRel();
        oat.setApiCode(pmsApiMangageApi.getApiCode());
        List<OcpApiTenantRel> apitenant = pmsApiManagementMapper.getApitenant(oat);
            for (OcpApiModelRel ocpApiModelRel : apiModel) {
                for (OcpApiTenantRel ocpApiTenantRel : apitenant) {
                    if (ocpApiModelRel.getApiCode().equals(pmsApiMangageApi.getApiCode())||ocpApiTenantRel.getApiCode().equals(pmsApiMangageApi.getApiCode())){
                        return ResponseResult.SUCCESS(false);
                    }
                }
            }
        pmsApiManagementMapper.deleteApi(pmsApiMangageApi);
        return ResponseResult.SUCCESS(true);
        }

    @Override
    public ResponseResult updateApi(PmsApiMangageApi pmsApiMangageApi) {
        pmsApiManagementMapper.updatePamm(pmsApiMangageApi);
        pmsApiMangageApi.setApiCode(pmsApiMangageApi.getApiGroupName());
        pmsApiManagementMapper.updateOag(pmsApiMangageApi);
        return new ResponseResult(CommonCode.SUCCESS);
    }


    private QueryWrapper<OcpApiBase> getCondition(String apiCode){
        QueryWrapper<OcpApiBase> qw = new QueryWrapper<>();

        if(StringUtils.isNotBlank(apiCode)){
            qw.eq("api_code",apiCode);
        }
        return qw;
    }

}
