package com.pms.ocp.common.config;

import com.pms.ocp.common.component.LogbackFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

/**
 * 过滤器配置类
 * 
 * @author wuwanli
 * @version 1.0
 * @date 2021/8/4
 */
@Configuration
public class FilterConfig {
	@Bean
	public FilterRegistrationBean<LogbackFilter> getLogbackFilter() {
		FilterRegistrationBean<LogbackFilter> logbackFilter = new FilterRegistrationBean<>(new LogbackFilter());
		logbackFilter.addUrlPatterns("/*");
		logbackFilter.setOrder(Ordered.HIGHEST_PRECEDENCE);
		return logbackFilter;
	}
}
