package com.pms.ocp.common.constants;

public enum ChooseDateType {
    ONE_WEEK(1, "最近一周"),
    ONE_MONTH(2, "最近一个月"),
    THREE_MONTHS(3, "最近三个月");
    private Integer code;
    private String desc;

    ChooseDateType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static ChooseDateType getChooseDateType(Integer code) {
        ChooseDateType[] values = ChooseDateType.values();
        for (ChooseDateType c : values) {
            if (c.getCode().equals(code)) {
                return c;
            }
        }
        return null;
    }
}
