package com.pms.ocp.controller;


import com.pms.ocp.model.dto.OcpTenantGroupIocnDto;
import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.OcpTenantBaseService;
import com.pms.ocp.service.OcpTenantIocnService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RequestMapping("/tenant-group/v1")
@RestController
@Api(tags = "我的应用-服务列表")
public class OcpTenantGroupIocnController {


    @Autowired
    private OcpTenantIocnService ocpTenantIocnService;

    @Autowired
    private OcpTenantBaseService ocpTenantBaseService;



    /**
     * 我的应用--服务列表
     * @return
     */
    @GetMapping("/applyuser")
    @ApiModelProperty("我的应用--服务列表")
    private ResponseVO<List<OcpTenantGroupIocnDto>> getApplyUser() {
        List<OcpTenantGroupIocnDto> ocpgroup = ocpTenantIocnService.getApplyUserList();
        return ResponseVO.ok(ocpgroup);
    }

    /**
     * 我的应用--应用删除
     * @return
     */
    @GetMapping("/delectapplyuser")
    @ApiModelProperty("我的应用--应用删除")
    private ResponseVO delectApplyUser(String objId) {
        boolean falg = ocpTenantBaseService.delectApply(objId);
        return ResponseVO.ok(falg);
    }


}
