package com.pms.ocp.controller;

import com.pms.ocp.model.entity.*;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import java.util.List;

@Slf4j
@RequestMapping("/tenant")
@RestController
@Api(tags = "应用接口")
public class PmsTenantDetailsController {

    @Autowired
    private PmsTenantBaseService pmsTenantBaseService;

    @Autowired
    private PmsTenantAuditService pmsTenantAuditService;

    @Autowired
    private PmsTenantSubsService pmsTenantSubsService;

    @Autowired
    private PmsApiTenantRelService pmsApiTenantRelService;


    @ApiOperation("应用基础信息-查询")
    @PostMapping("/getotbList")
    public ResponseVO<List<PmsTenantBase>> getOtbList(@RequestBody PmsTenantBase pmsTenantBase){
        return pmsTenantBaseService.getOtbList(pmsTenantBase);
    }

    @ApiOperation("应用大事记-查询")
    @PostMapping("/getotaList")
    public ResponseVO<List<PmsTenantAudit>> getOtaList(PmsTenantAudit pmsTenantAudit) {
        return pmsTenantAuditService.getOtaList(pmsTenantAudit);
    }


    @ApiOperation("应用订阅记录-查询")
    @PostMapping("/getOcpTenantList")
    public ResponseVO<List<PmsTenantSubs>> getOcpTenantList(PmsTenantSubs pmsTenantSubs) {
        return pmsTenantSubsService.getOcpTenantList(pmsTenantSubs);
    }

    @ApiOperation("应用与服务拓扑图-查询")
    @PostMapping("/getOcpTenantApiList")
    public ResponseVO<List<PmsApiTenantRel>> getOcpTenantApiList(@RequestBody PmsApiTenantRel pmsApiTenantRel) {
        return pmsApiTenantRelService.getTenantApiList(pmsApiTenantRel);
    }

    @ApiOperation("应用大事记-导出")
    @PostMapping("/export")
    public void exportExcel(@RequestBody PmsTenantAudit pmsTenantAudit, HttpServletRequest request, HttpServletResponse response) {
        pmsTenantAuditService.exportExcel(pmsTenantAudit,request,response);
    }

    @ApiOperation("应用大事记-查询详情-变更内容")
    @PostMapping("/getocpTent")
    public ResponseVO<List<PmsTenantAudit>> getOcpTenant(@RequestBody PmsTenantAudit pmsTenantAudit){
        return pmsTenantAuditService.OtaById(pmsTenantAudit);
    }

    @ApiOperation("应用大事记-查询详情-历史版本")
    @PostMapping("/versionId")
    public ResponseVO<List<PmsTenantAudit>> versionId(@RequestBody PmsTenantAudit pmsTenantAudit){
        return pmsTenantAuditService.versionId(pmsTenantAudit);
    }


}
