package com.pms.ocp.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("服务列表查询参数")
public class ApiBaseDto implements Serializable {

    @ApiModelProperty("服务编码")
    private String apiCode;

    @ApiModelProperty("服务分类编码")
    private String apiGroupCode;

    @ApiModelProperty("服务分类公司()")
    private String apiGroupCompanyCode;

    @ApiModelProperty("建设单位")
    private String apiUnit;

    @ApiModelProperty("推广类型0:统建；1:自建")
    private Integer apiPromotion;

    @ApiModelProperty("注册时段-开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Timestamp startTime;

    @ApiModelProperty("注册时段-结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Timestamp endTime;

    @ApiModelProperty("注册开始")
    private String startCTime;

    @ApiModelProperty("注册结束")
    private String endCTime;

    @ApiModelProperty("关键字")
    private String keyword;

    @ApiModelProperty("当前页")
    private Integer pageNum;

    @ApiModelProperty("每页条数")
    private Integer pageSize;


    private List<String> apiGroupCodeList;

    public Integer getApiPromotion() {
        return apiPromotion;
    }

    public void setApiPromotion(Integer apiPromotion) {
        this.apiPromotion = apiPromotion;
    }

    public String getApiCode() {
        return apiCode;
    }

    public void setApiCode(String apiCode) {
        this.apiCode = apiCode;
    }

    public String getApiGroupCode() {
        return apiGroupCode;
    }

    public void setApiGroupCode(String apiGroupCode) {
        this.apiGroupCode = apiGroupCode;
    }

    public Timestamp getStartTime() {
        return startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getEndTime() {
        return endTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public String getStartCTime() {
        return startCTime;
    }

    public void setStartCTime(String startCTime) {
        this.startCTime = startCTime;
    }

    public String getEndCTime() {
        return endCTime;
    }

    public void setEndCTime(String endCTime) {
        this.endCTime = endCTime;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getApiGroupCompanyCode() {
        return apiGroupCompanyCode;
    }

    public void setApiGroupCompanyCode(String apiGroupCompanyCode) {
        this.apiGroupCompanyCode = apiGroupCompanyCode;
    }

    public String getApiUnit() {
        return apiUnit;
    }

    public void setApiUnit(String apiUnit) {
        this.apiUnit = apiUnit;
    }

    public List<String> getApiGroupCodeList() {
        return apiGroupCodeList;
    }

    public void setApiGroupCodeList(List<String> apiGroupCodeList) {
        this.apiGroupCodeList = apiGroupCodeList;
    }
}
