package com.pms.ocp.model.dto;

import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.model.entity.OcpTenantGroup;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class GroupDto extends OcpTenantGroup implements Serializable {
    @ApiModelProperty("应用名称")
    private String tenantName;

    /**
     * 应用代码
     */
    @ApiModelProperty("应用代码")
    private String tenantCode;

    @ApiModelProperty("flag")
    private Integer flag;


    /**
     * 应用分类代码
     */
    @ApiModelProperty("应用分类代码")
    private String tenantGroupCode;

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getTenantGroupCode() {
        return tenantGroupCode;
    }

    public void setTenantGroupCode(String tenantGroupCode) {
        this.tenantGroupCode = tenantGroupCode;
    }
}
