package com.pms.ocp.model.dto;

import com.pms.ocp.common.config.CreateGroups;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 应用预览图入参
 *
 * @author Administrator
 */
@Data
public class ImgDTO {

    @ApiModelProperty(value = "应用编码")
    @NotBlank(message = "应用编码值不能为空", groups = CreateGroups.class)
    private String codeNo;

    @ApiModelProperty(value = "应用预览url")
    @NotBlank(message = "应用预览url不能为空", groups = CreateGroups.class)
    private String img;

    public String getCodeNo() {
        return codeNo;
    }

    public void setCodeNo(String codeNo) {
        this.codeNo = codeNo;
    }

    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }
}

