package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.sql.Timestamp;

@Data
@Accessors(chain = true)
@ApiModel("服务管理")
public class PmsApiManagement {

    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    private String objId;

    @ApiModelProperty("服务代码")
    private String apiCode;

    @ApiModelProperty("服务接口中文名称")
    private String apiName;

    @ApiModelProperty("服务分类代码")
    private String apiGroupCode;

    @ApiModelProperty("推广类型0:统建；1:自建")
    private long apiPromotion;

    @ApiModelProperty("服务请求体")
    private String apiReq;

    @ApiModelProperty("服务返回体")
    private String apiResp;

    @ApiModelProperty("服务地址")
    private String apiUrl;

    @ApiModelProperty("服务创建时间")
    private Timestamp apiCtime;

    @ApiModelProperty("服务修改时间")
    private Timestamp apiMtime;

    @ApiModelProperty("创建者用户ID")
    private String apiUserId;

    @ApiModelProperty("建设单位")
    private String apiUnit;

    @ApiModelProperty("服务所属公司")
    private String ownerCompanyCode;

    @ApiModelProperty("是否删除0-否1-是")
    private long isDelete;

    @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
    private long apiZone;

    @ApiModelProperty("'所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
    private long apiLayer;

    @ApiModelProperty("服务版本（最新版本）")
    private String apiVersion;

    @ApiModelProperty("服务所属中心编码所属中心")
    private String apiCenterCode;

    @ApiModelProperty("服务简述")
    private String apiDescription;

    @ApiModelProperty("创建者姓名")
    private String apiUserName;

    //

    @ApiModelProperty("分类名称")
    private String apiGroupName;

    @ApiModelProperty("推广类型0统推，1自建")
    private long apiGroupPromotionType;

    @ApiModelProperty("分类所属公司")
    private String apiGroupCompanyCode;

    @ApiModelProperty("分类版本")
    private String apiGroupVersion;

    @ApiModelProperty("显示顺序")
    private long apiGroupOrderNo;

    @ApiModelProperty("提交人id")
    private String apiGroupUserId;

    @ApiModelProperty("提交人姓名")
    private String apiGroupUserName;

    @ApiModelProperty("创建时间")
    private Timestamp apiGroupCtime;

    @ApiModelProperty("修改时间")
    private Timestamp apiGroupMtime;

    @ApiModelProperty("上级code")
    private String apiGroupPcode;

    @ApiModelProperty("分层树层级 1中台层 2中心层 3 服务组层 4服务层 ")
    private String apiGroupLevel;


    //
    @ApiModelProperty("图标种类tenant:应用图标api:服务图标")
    private String iocnType;

    @ApiModelProperty("编码值")
    private String codeNo;

    @ApiModelProperty("应用调用的服务数量图标数据")
    private Object iocn;

    @ApiModelProperty("所属公司可能会根据公司分区")
    private String companyCode;

    @ApiModelProperty("当前页")
    private Integer currentPage;

    @ApiModelProperty("每页条数")
    private Integer pageSize;

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
