package com.pms.ocp.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/3/10 19:24
 * @Description:模型关系VO对象
 */

@ApiModel(value = "模型关系VO对象")
@Data
public class ModelRelationVO {

    /**
     * 模型关系编号
     * 主键
     */
    @ApiModelProperty(value = "模型关系编号")
    private String objId;

    /**
     * 模型编码
     */
    @ApiModelProperty(value = "模型编码")
    private String modelCode;

    /**
     * 模型属性编码
     */
    @ApiModelProperty(value = "模型属性编码")
    private String modelPropCode;

    /**
     * 关联模型编码
     */
    @ApiModelProperty(value = "关联模型编码")
    private String relationModeCode;

    /**
     * 关联模型属性编码
     */
    @ApiModelProperty(value = "关联模型属性编码")
    private String relationModePropCode;

    /**
     * 提交人id
     */
    @ApiModelProperty(value = "提交人编号")
    private String modelUserId;


    /**
     * 提交人姓名
     */
    @ApiModelProperty(value = "提交人姓名")
    private String modelUserName;

    /**
     * 订阅时间
     */
    @ApiModelProperty(value = "订阅时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modelCtime;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modelMtime;

    /**
     * 是否已删除 0:未删除 1:已删除
     */
    @ApiModelProperty(value = "是否已删除")
    private String boolDelete;
}
