package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.pms.ocp.mapper.ModelPropertyMapper;
import com.pms.ocp.model.dto.ModelPropertyDTO;
import com.pms.ocp.model.entity.Model;
import com.pms.ocp.model.entity.ModelProperty;
import com.pms.ocp.model.vo.ModelPropertyVO;
import com.pms.ocp.service.ModelPropertyService;
import com.pms.ocp.service.ModelService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:21
 * @Description:模型属性业务层实现
 */

@Service
public class ModelPropertyServiceImpl implements ModelPropertyService {

    @Autowired
    private ModelPropertyMapper modelPropertyMapper;

    @Autowired
    private ModelService modelService;

    @Override
    public Integer createModelProperty(ModelPropertyDTO modelPropertyDTO) {

        ModelProperty modelProperty = new ModelProperty();

        BeanUtils.copyProperties(modelPropertyDTO, modelProperty);

        modelProperty.setPropCtime(LocalDateTime.now());
        return modelPropertyMapper.insert(modelProperty);
    }

    @Override
    public Integer deleteModelProperty(String modelCode, String propCode) {
        QueryWrapper<ModelProperty> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelProperty::getModelCode, modelCode);
        }

        if (StringUtils.isNotEmpty(propCode)) {
            queryWrapper.lambda().eq(ModelProperty::getPropCode, propCode);
        }
        return modelPropertyMapper.delete(queryWrapper);
    }

    @Override
    public Integer deleteBatchModelProperty(List<String> ids) {
        return modelPropertyMapper.deleteBatchIds(ids);
    }

    @Override
    public Integer updateModelProperty(ModelPropertyDTO modelPropertyDTO) {

        ModelProperty modelProperty = new ModelProperty();

        BeanUtils.copyProperties(modelPropertyDTO, modelProperty);

        modelProperty.setPropMtime(LocalDateTime.now());

        UpdateWrapper<ModelProperty> updateWrapper = new UpdateWrapper<>();

        updateWrapper.lambda().eq(ModelProperty::getObjId, modelProperty.getObjId());

        return modelPropertyMapper.update(modelProperty, updateWrapper);
    }

    @Override
    public List<ModelProperty> listModelProperty(String objId, String modelCode, String propCode) {

        QueryWrapper<ModelProperty> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(ModelProperty::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelProperty::getModelCode, modelCode);
        }

        if (StringUtils.isNotEmpty(propCode)) {
            queryWrapper.lambda().eq(ModelProperty::getPropCode, propCode);
        }

        return modelPropertyMapper.selectList(queryWrapper);
    }

    @Override
    public List<ModelPropertyVO> listModelPropertyVO(Integer currentPage, Integer pageSize,
                                                     String modelCode, String ownerCompanyCode, String modelGroupCode) {




////        PageHelper.startPage(currentPage, pageSize);
//
//        List<ModelProperty> modelPropertyList = listModelProperty(objId, modelCode, propCode);
////        List<ModelPropertyVO> modelPropertyVOList = modelPropertyService.listModelPropertyVO(objId, modelCode, subsCompanyCode);
//        Model model = modelService.getModel(objId, modelCode);
//
//        List<ModelPropertyVO> modelPropertyVOList = new ArrayList<>(modelPropertyList.size());
//
////        组合模型与属性相关属性值
//        if (model != null && !modelPropertyList.isEmpty()) {
//            modelPropertyVOList = modelPropertyList.stream().map(modelProperty -> {
//                ModelPropertyVO modelPropertyVO = new ModelPropertyVO();
//                BeanUtils.copyProperties(modelProperty, modelPropertyVO);
////                modelPropertyVO.setModelTableName(model.getModelTable());
//                return modelPropertyVO;
//            }).collect(Collectors.toList());
//        }

//        PageInfo<ModelPropertyVO> pageInfo = new PageInfo<>(modelPropertyVOList);
        return modelPropertyMapper.listModelPropertyVO(modelCode, ownerCompanyCode, modelGroupCode);
    }

    /**
     * TODO
     *
     * @return
     */
    @Override
    public ModelPropertyDTO getModelProperty() {
        QueryWrapper<ModelProperty> wrapper = new QueryWrapper<>();
        return null;
    }

}
