package com.pms.ocp.service.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.mapper.OcpTenantBaseMapper;
import com.pms.ocp.mapper.OcpTenantIocnMapper;
import com.pms.ocp.model.dto.OcpTenantGroupIocnDto;
import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.model.entity.OcpTenantIocn;
import com.pms.ocp.service.OcpTenantIocnService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


@Service
public class OcpTenantIocnServiceImpl extends ServiceImpl<OcpTenantIocnMapper, OcpTenantIocn> implements OcpTenantIocnService {


    @Autowired
    private OcpTenantBaseMapper ocpTenantBaseMapper;

    @Autowired
    private OcpTenantIocnMapper ocpTenantIocnMapper;

    /**
     * 我的应用--服务列表
     *
     * @return
     */
    @Override
    public List<OcpTenantGroupIocnDto> getApplyUserList() {
        List<OcpTenantGroupIocnDto> groupIocnDtos = new ArrayList<>();
        List<OcpTenantBase> ocpTenantBases = ocpTenantBaseMapper.selectList(null);
        List<OcpTenantIocn> ocpTenantIocns = ocpTenantIocnMapper.selectList(null);
        List<String> companyCodes = new ArrayList<>();
        for (OcpTenantBase ocpTenantBase : ocpTenantBases) {
            OcpTenantGroupIocnDto ocpTenantGroupIocnDto = new OcpTenantGroupIocnDto();
            if (ocpTenantBase.getIsDelete() == 0) {
                BeanUtils.copyProperties(ocpTenantBase, ocpTenantGroupIocnDto);
                String ownerCompanyCode = ocpTenantBase.getOwnerCompanyCode();
                ocpTenantGroupIocnDto.setCompanyCode(ownerCompanyCode);
                groupIocnDtos.add(ocpTenantGroupIocnDto);
                for (OcpTenantIocn ocpTenantIocn : ocpTenantIocns) {
                    if (ocpTenantIocn.getCompanyCode().equals(ocpTenantBase.getOwnerCompanyCode())){
                        BeanUtils.copyProperties(ocpTenantIocn, ocpTenantGroupIocnDto);
                    }
                }
            }
        }
        return groupIocnDtos;
    }


}
