package com.pms.ocp.service.impl;


import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.common.constants.AnalysisConstant;
import com.pms.ocp.common.constants.ExportUtils;
import com.pms.ocp.mapper.OcpApiAuditMapper;
import com.pms.ocp.mapper.PmsApiAuditMapper;
import com.pms.ocp.model.entity.OcpApiAudit;
import com.pms.ocp.model.entity.PmsApiAudit;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.PmsApiAuditService;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Service
public class PmsApiAuditServiceImpl extends ServiceImpl<PmsApiAuditMapper,PmsApiAudit> implements PmsApiAuditService {

    @Autowired
    private PmsApiAuditMapper pmsApiAuditMapper;

    @Override
    public ResponseVO getOcpApiAuditList(PmsApiAudit pmsApiAudit) {
        List<PmsApiAudit> pmsApiAuditList = pmsApiAuditMapper.getOcpApiSubsList(pmsApiAudit);
        return ResponseVO.ok(pmsApiAuditList);
    }


    @Override
    public ResponseVO getOcpApiDetails(String objId) {
        PmsApiAudit pmsApiAudit = pmsApiAuditMapper.selectById(objId);
        return ResponseVO.ok(pmsApiAudit);
    }

    @Override
    public ResponseVO OaaById(PmsApiAudit pmsApiAudit) {
        List<PmsApiAudit> paam = pmsApiAuditMapper.OaaById(pmsApiAudit);
        return ResponseVO.ok(paam);
    }

    @Override
    public ResponseVO sById(PmsApiAudit pmsApiAudit) {
        List<PmsApiAudit> oaaById = pmsApiAuditMapper.sById(pmsApiAudit);
        return ResponseVO.ok(oaaById);
    }

    @Override
    public void exportExcel(PmsApiAudit pmsApiAudit, HttpServletRequest request, HttpServletResponse response) {
        List<PmsApiAudit> oaaById = pmsApiAuditMapper.OaaById(pmsApiAudit);
        ExportParams param = new ExportParams(AnalysisConstant.exportOcpApiAuditName.OCPAPIAUDITNAME,AnalysisConstant.exportOcpApiAuditName.OCPAPIAUDITNAME);
        Workbook workbook = ExcelExportUtil.exportExcel(param,PmsApiAudit.class,oaaById);
        ExportUtils.exportExcel(response, AnalysisConstant.exportOcpApiAuditName.OCPAPIAUDIT,workbook);
    }

    @Override
    public ResponseVO versionId(PmsApiAudit pmsApiAudit) {
        List<PmsApiAudit> pmsApiAuditList = pmsApiAuditMapper.versionId(pmsApiAudit);
        return ResponseVO.ok(pmsApiAuditList);
    }


}
