package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.pms.ocp.mapper.PmsApiManagementMapper;
import com.pms.ocp.model.entity.PmsApiManagement;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.PmsApiManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class PmsApiManagementServiceImpl extends ServiceImpl<PmsApiManagementMapper, PmsApiManagement> implements PmsApiManagementService {

    @Autowired
    private PmsApiManagementMapper pmsApiManagementMapper;



    @Override
    public ResponseVO<PageInfo<PmsApiManagement>> getPammList(PmsApiManagement pmsApiManagement) {
        if (pmsApiManagement.getCurrentPage() ==null || pmsApiManagement.getPageSize() == null) {
            return ResponseVO.error("分页参数不能为空");
        }
        PageHelper.startPage(pmsApiManagement.getCurrentPage(),pmsApiManagement.getPageSize());
        List<PmsApiManagement> pammList = pmsApiManagementMapper.getPammList(pmsApiManagement);
        PageInfo<PmsApiManagement> pageInfo = new PageInfo<>(pammList);
        return ResponseVO.ok(pageInfo);
    }

    @Override
    public ResponseVO getPammByCode(PmsApiManagement pmsApiManagement) {
        List<PmsApiManagement> pammByCode = pmsApiManagementMapper.getPammByCode(pmsApiManagement);
        return ResponseVO.ok(pammByCode);
    }
}
