package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.pms.ocp.mapper.*;
import com.pms.ocp.model.dto.GroupDto;

import com.pms.ocp.model.dto.OcpBaseTiocnDto;
import com.pms.ocp.model.dto.OcpTenantBaseDto;
import com.pms.ocp.model.dto.TenantDto;
import com.pms.ocp.model.entity.*;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.model.vo.TenantGroupVo;
import com.pms.ocp.service.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Slf4j
@Transactional
public class TenantBasicManagementServiceImpl extends ServiceImpl<TenantBasicManagementMapper, OcpTenantBase> implements TenantBasicManagementService {
    @Autowired
    private TenantBasicManagementMapper tenantBasicManagementMapper;
    @Autowired
    private OcpTenantExtentMapper ocpTenantExtentMapper;
    @Autowired
    private OcpTenantSubsService ocpTenantSubsService;
    @Autowired
    private OcpApiTenantRelService ocpApiTenantRelService;
    @Autowired
    private OcpApiTenantRelMapper ocpApiTenantRelMapper;
    @Autowired
    private OcpTenantGroupService ocpTenantGroupService;
    @Autowired
    private OcpTenantGroupMapper ocpTenantGroupMapper;
    @Autowired
    private OcpTenantAuditMapper ocpTenantAuditMapper;
    @Autowired
    private OcpTenantIocnService ocpTenantIocnService;
    @Autowired
    private ApiBasicManagementMapper apiBasicManagementMapper;
    List<String> tenantGroup = new ArrayList<>();

    /**
     * 条件查询
     *
     * @param tenantCode
     * @param keyword
     * @param tenantUnit
     * @param startTime
     * @param endTime
     * @param pageSize
     * @param pageNum
     * @return
     */
    @Override
    public List<OcpTenantBaseDto> queryOcpTenantBaseDto(String tenantGroupCode, String tenantCode, String keyword, String tenantUnit, Timestamp startTime, Timestamp endTime, Integer pageSize, Integer pageNum) {
//        if (pageSize == 0 || pageNum == 0) {
//            ResponseVO.error("分页参数不能为空");
//        }
        pageSize = (pageSize - 1) * pageNum;
        return tenantBasicManagementMapper.queryOcpTenantBaseDto(tenantGroupCode, keyword, tenantUnit, startTime, endTime, tenantCode, pageSize, pageNum);
    }

    /**
     * 应用发布  改变其应用状态
     *
     * @param tenantCodes 应用代码
     * @return
     */
    @Override
    public ResponseVO tenantIssue(String tenantCodes) {
        if (StringUtils.isEmpty(tenantCodes)) {
            return ResponseVO.error("请选择要发布的应用");
        }
        String[] split = tenantCodes.split(",");
        List<String> list = Arrays.asList(split);
        LambdaQueryWrapper<OcpTenantExtent> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(OcpTenantExtent::getTenantCode, list);
        List<OcpTenantExtent> ocpTenantExtents = ocpTenantExtentMapper.selectList(lambdaQueryWrapper);
        for (OcpTenantExtent ocpTenantExtent : ocpTenantExtents) {
            String tenantCode = ocpTenantExtent.getTenantCode();
            if (ocpTenantExtent.getTenantState() == null) {
                return ResponseVO.error("数据错误,状态为空");
            } else if (ocpTenantExtent.getTenantState() == 1) {
                return ResponseVO.error(tenantCode + "已发布,请勿重复操作");
            }
//            else if (ocpTenantExtent.getTenantState() == 2) {
//                return ResponseVO.error(tenantCode + "已下线,无法发布");
//            }
            else {
                ocpTenantExtent.setTenantState((short) 1);
                ocpTenantExtentMapper.updateById(ocpTenantExtent);
            }
        }
        return ResponseVO.ok();
    }

    /**
     * 应用订阅
     *
     * @param tenantCodes
     */
    @Override
    public ResponseVO tenantLogin(String tenantCodes, String companyCode) {
        if (StringUtils.isEmpty(tenantCodes)) {
            return ResponseVO.error("请选择要订阅的应用");
        }
//        if (StringUtils.isEmpty(companyCode)) {
//            return ResponseVO.error("公司编码为空");
//        }
        String[] split = tenantCodes.split(",");
        List<String> tenantCode = Arrays.asList(split);
        for (String s : tenantCode) {
            OcpTenantSubs ocpTenantSubs = new OcpTenantSubs();
            ocpTenantSubs.setTenantCode(s);
            if (StringUtils.isNotEmpty(companyCode)) {
                ocpTenantSubs.setSubsCompanyCode(companyCode);
            } else {
                ocpTenantSubs.setSubsCompanyCode("1");
            }
            ocpTenantSubs.setSubsLogTenantAtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpTenantSubs.setSubsLogTenantCtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpTenantSubs.setSubsLogTenantMtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpTenantSubs.setIsDelete((short) 0);
            ocpTenantSubsService.save(ocpTenantSubs);
        }
        return ResponseVO.ok("订阅成功");
    }

    /**
     * 应用下线
     *
     * @param tenantCodes
     */
    @Override
    public ResponseVO tenantCancel(String tenantCodes) {
        if (StringUtils.isEmpty(tenantCodes)) {
            return ResponseVO.error("请选择要下线的应用");
        }

        String[] split = tenantCodes.split(",");
        List<String> list = Arrays.asList(split);

//        LambdaQueryWrapper<OcpTenantExtent> lambdaQueryWrapper = new LambdaQueryWrapper<>();
//        lambdaQueryWrapper.in(OcpTenantExtent::getTenantCode, list);
//        List<OcpTenantExtent> ocpTenantExtents = ocpTenantExtentMapper.selectList(lambdaQueryWrapper);

        LambdaQueryWrapper<OcpTenantAudit> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(OcpTenantAudit::getTenantCode, list);
        List<OcpTenantAudit> ocpTenantExtents = ocpTenantAuditMapper.selectList(lambdaQueryWrapper);

        if (ocpTenantExtents.size() == 0) {
            return ResponseVO.error("系统错误,数据为空");
        }
        for (OcpTenantAudit ocpTenantExtent : ocpTenantExtents) {
            String tenantCode = ocpTenantExtent.getTenantCode();
            if (ocpTenantExtent.getOperStatus() == null) {
                return ResponseVO.error("系统错误,状态为空");
            } else if (ocpTenantExtent.getOperStatus() == 2) {

                return ResponseVO.error(tenantCode + "已下线,请勿重复下线");
            } else {
                ocpTenantExtent.setOperStatus((short) 2);
                ocpTenantAuditMapper.updateById(ocpTenantExtent);
            }

        }
        return ResponseVO.ok("操作成功");
    }

    /**
     * 应用注册
     *
     * @param ocpTenantBaseDto
     */
    @Override
    public ResponseVO applyRegister(OcpTenantBaseDto ocpTenantBaseDto) {
//        OcpTenantBase
        String tenantGroupName = ocpTenantBaseDto.getTenantGroupName();//应用分类名称
        LambdaQueryWrapper<OcpTenantGroup> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(OcpTenantGroup::getTenantGroupName, tenantGroupName);
        OcpTenantGroup one = ocpTenantGroupService.getOne(lambdaQueryWrapper);
        if (one == null) {
            return ResponseVO.error("该应用分类不存在");
        }
//
        String tenantCode = ocpTenantBaseDto.getTenantCode();
//        LambdaQueryWrapper<OcpTenantBase> lambdaQueryWrapper = new LambdaQueryWrapper<>();
//        lambdaQueryWrapper.eq(OcpTenantBase::getTenantCode, tenantCode);
//        List<OcpTenantBase> ocpTenantBases = tenantBasicManagementMapper.selectList(lambdaQueryWrapper);
//        if (ocpTenantBases.size() != 1) {
//            return ResponseVO.error("应用代码应该唯一");
//        }
//        for (OcpTenantBase ocpTenantBase : ocpTenantBases) {
//            System.out.println(ocpTenantBase);
//            BeanUtils.copyProperties(ocpTenantBaseDto, ocpTenantBase);
//            this.update(lambdaQueryWrapper);
//        }
        String apiCodes = ocpTenantBaseDto.getApiCodes();
        if (StringUtils.isEmpty(apiCodes)) {
            return ResponseVO.error("服务编码为空");
        }
//        //获取应用分类编码
        String tenantGroupCode = one.getTenantGroupCode();

        OcpTenantBase ocpTenantBase = new OcpTenantBase();
        BeanUtils.copyProperties(ocpTenantBaseDto, ocpTenantBase);
        ocpTenantBase.setTenantGroupCode(tenantGroupCode);
        //OcpTenantBase
        tenantBasicManagementMapper.insert(ocpTenantBase);

//        //ocp_tenant_extent
        OcpTenantExtent ocpTenantExtent = new OcpTenantExtent();
        BeanUtils.copyProperties(ocpTenantBaseDto, ocpTenantExtent);
        ocpTenantExtent.setDepCompanyCode(null);
        ocpTenantExtentMapper.insert(ocpTenantExtent);

        //ocp_api_tenant_rel

        OcpApiTenantRel ocpApiTenantRel = new OcpApiTenantRel();
        String[] split = apiCodes.split(",");
        List<String> apiCode = Arrays.asList(split);

        for (String s : apiCode) {
            ocpApiTenantRel.setApiCode(s);
            ocpApiTenantRel.setTenantDepCompanyCode("078002018");
            ocpApiTenantRel.setApiDepCompanyCode("078002018");
            ocpApiTenantRel.setTenantCode(tenantCode);
            ocpApiTenantRel.setApiTenantRelCtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpApiTenantRel.setApiTenantRelMtime(Timestamp.valueOf(LocalDateTime.now()));
            //保存到数据库
            ocpApiTenantRelService.save(ocpApiTenantRel);
        }

        return ResponseVO.ok();
    }

    /**
     * 应用树层级
     *
     * @param tenantGroupCode
     * @param tenantGroupCompanyCode
     * @return
     */
    @Override
    public List<GroupDto> tenantBaseTreeOther(String tenantGroupCode, String tenantGroupCompanyCode, String tenantCode) {
        List<GroupDto> ocpTenantGroups = ocpTenantGroupMapper.tenantBaseTreeOther(tenantGroupCode, tenantGroupCompanyCode);
        if (ocpTenantGroups.size() != 0) {
            return ocpTenantGroups;
        } else {
            if (StringUtils.isNotEmpty(tenantCode)) {
                return Collections.EMPTY_LIST;
            } else {
                List<GroupDto> groupDtos = ocpTenantGroupMapper.selectBase(tenantGroupCode, tenantGroupCompanyCode);
                if (groupDtos.size() != 0) {
                    return groupDtos;
                }
                return Collections.EMPTY_LIST;
            }

        }

    }

    /**
     * 应用列表
     *
     * @param tenantDto
     * @return
     */
    @Override
    public ResponseVO<PageInfo<OcpTenantBaseDto>> getBaseByGroupCode(TenantDto tenantDto) {
        if (tenantDto.getCurrentPage() == null || tenantDto.getPageSize() == null) {
            return ResponseVO.error("分页参数不能为空");
        }
        tenantGroup.add(tenantDto.getTenantGroupCode());
        setGroupIdValue(tenantDto.getTenantGroupCompanyCode(), tenantDto.getTenantGroupCode());
        PageHelper.startPage(tenantDto.getCurrentPage(), tenantDto.getPageSize());
        tenantDto.setApiGroupCodeList(tenantGroup);
        List<OcpTenantBaseDto> ocpTenantBaseDto = ocpTenantGroupMapper.selectPageLists(tenantDto);
        tenantGroup.clear();
        PageInfo<OcpTenantBaseDto> pageInfo = new PageInfo<>(ocpTenantBaseDto);
        return ResponseVO.ok(pageInfo);

    }

    /**
     * 应用树底层
     *
     * @param tenantGroupCode
     * @param tenantGroupCompanyCode
     * @return
     */
    @Override
    public List<OcpTenantBase> tenantBaseTree(String tenantGroupCode, String tenantGroupCompanyCode) {
        LambdaQueryWrapper<OcpTenantBase> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(StringUtils.isNotEmpty(tenantGroupCompanyCode), OcpTenantBase::getOwnerCompanyCode, tenantGroupCompanyCode);
        lambdaQueryWrapper.eq(StringUtils.isNotEmpty(tenantGroupCode), OcpTenantBase::getTenantGroupCode, tenantGroupCode);

        List<OcpTenantBase> ocpTenantBases = tenantBasicManagementMapper.selectList(lambdaQueryWrapper);

        return ocpTenantBases;
    }

    /**
     * 应用树底层
     *
     * @param tenantGroupCode
     * @param tenantGroupCompanyCode
     * @return
     */
    public List<GroupDto> selectBase(String tenantGroupCode, String tenantGroupCompanyCode) {
        List<GroupDto> groupDto = ocpTenantGroupMapper.selectBase(tenantGroupCode, tenantGroupCompanyCode);
        return groupDto;
    }

    /**
     * 省测-应用接入申请-编辑和添加应用服务关系
     *
     * @param ocpBaseTiocnDto
     * @return
     */
    @Override
    public ResponseVO updateByCondition(OcpBaseTiocnDto ocpBaseTiocnDto) {
        String tenantCode = ocpBaseTiocnDto.getTenantCode();
        String ownerCompanyCode = ocpBaseTiocnDto.getOwnerCompanyCode();
        //先删除应用服务关联
        LambdaQueryWrapper<OcpApiTenantRel> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
        lambdaQueryWrapper1.eq(OcpApiTenantRel::getTenantCode, tenantCode);
        boolean remove1 = ocpApiTenantRelService.remove(lambdaQueryWrapper1);
        if (remove1) {
            log.info("要是有关联先删除,删除成功");
        }
        String apiCodes = ocpBaseTiocnDto.getApiCodes();
        if (StringUtils.isEmpty(apiCodes)) {
            return ResponseVO.ok("没有关联服务");
        }
        String[] split = apiCodes.split(",");
        List<String> apiCode = Arrays.asList(split);
        for (String s : apiCode) {
            OcpApiTenantRel ocpApiTenantRel = new OcpApiTenantRel();
            ocpApiTenantRel.setTenantCode(tenantCode);
            ocpApiTenantRel.setApiCode(s);
            ocpApiTenantRel.setApiDepCompanyCode(ownerCompanyCode);
            ocpApiTenantRel.setTenantDepCompanyCode(ownerCompanyCode);
            ocpApiTenantRel.setApiTenantRelCtime(new Timestamp(System.currentTimeMillis()));
            ocpApiTenantRel.setApiTenantRelMtime(new Timestamp(System.currentTimeMillis()));
            boolean save1 = ocpApiTenantRelService.save(ocpApiTenantRel);
            if (save1) {
                log.info("添加关联表成功");
            }
        }
        return ResponseVO.ok();
    }

    /**
     * 省测-应用接入申请-查询和应用关联的服务
     *
     * @param tenantCode
     * @return
     */
    @Override
    public ResponseVO<List<OcpApiBase>> selectOcpByApi(String tenantCode) {
        LambdaQueryWrapper<OcpApiTenantRel> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(StringUtils.isNotEmpty(tenantCode), OcpApiTenantRel::getTenantCode, tenantCode);
        List<OcpApiTenantRel> ocpApiTenantRel = ocpApiTenantRelMapper.selectList(lambdaQueryWrapper);
        List<OcpApiBase> list = new ArrayList<>();
        if (ocpApiTenantRel.size() == 0) {
            return ResponseVO.ok(Collections.EMPTY_LIST);
        } else {
            for (OcpApiTenantRel apiTenantRel : ocpApiTenantRel) {
                LambdaQueryWrapper<OcpApiBase> queryWrapper = new LambdaQueryWrapper<>();
                String apiCode = apiTenantRel.getApiCode();
                queryWrapper.eq(StringUtils.isNotEmpty(apiCode), OcpApiBase::getApiCode, apiCode);
                OcpApiBase ocpApiBase = apiBasicManagementMapper.selectOne(queryWrapper);
                list.add(ocpApiBase);

            }

        }
        return ResponseVO.ok(list);
    }

    /**
     * 省测-应用接入申请-编辑和发布应用
     *
     * @param ocpBaseTiocnDto
     * @return
     */
    @Override
    public ResponseVO saveAndUpdateTenant(OcpBaseTiocnDto ocpBaseTiocnDto) {
        String tenantCode = ocpBaseTiocnDto.getTenantCode();
        OcpTenantBase ocpTenantBase = new OcpTenantBase();
        BeanUtils.copyProperties(ocpBaseTiocnDto, ocpTenantBase);
        LambdaQueryWrapper<OcpTenantBase> lambdaQueryWrapper2 = new LambdaQueryWrapper<>();
        lambdaQueryWrapper2.eq(OcpTenantBase::getTenantCode, tenantCode);
//        boolean flag = this.update(ocpTenantBase, lambdaQueryWrapper2);
//        if (flag) {
//            log.info("应用基础表修改成功");
//            System.out.println("应用基础表修改成功");
//        }
        int delete = tenantBasicManagementMapper.delete(lambdaQueryWrapper2);
        if (delete == 0) {
            log.info("增加");
        } else {
            log.info("编辑");
        }
        boolean save1 = this.save(ocpTenantBase);
        if (save1) {
            log.info("基础表添加成功");
        }

        LambdaQueryWrapper<OcpTenantIocn> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(OcpTenantIocn::getCodeNo, tenantCode);
        boolean remove = ocpTenantIocnService.remove(lambdaQueryWrapper);
        if (remove) {
            log.info("图标表删除成功");
            System.out.println("图标表删除成功");
        }

        //添加新的数据到图标表
        OcpTenantIocn ocpTenantIocn = new OcpTenantIocn();
        Object iocn = ocpBaseTiocnDto.getIocn();
        String ownerCompanyCode = ocpBaseTiocnDto.getOwnerCompanyCode();
        ocpTenantIocn.setCodeNo(tenantCode);
        ocpTenantIocn.setIocnType("tenant");
        ocpTenantIocn.setIocn(iocn);
        ocpTenantIocn.setCompanyCode(ownerCompanyCode);
        boolean save = ocpTenantIocnService.save(ocpTenantIocn);
        if (save) {
            log.info("添加图标表成功");
            System.out.println("添加图标表成功");
        }
        if (save1 && save) {
            return ResponseVO.ok("添加成功");
        }
        return ResponseVO.error("未知错误");
    }

    /**
     * 应用树2
     *
     * @param tenantGroupCode
     * @return
     */

    public void setGroupIdValue(String tenantGroupCompanyCode, String tenantGroupCode) {
        List<String> codes = getIdsByPIdPub(tenantGroupCompanyCode, tenantGroupCode);
        if (codes.size() > 0) {
            for (String cod : codes) {
                setGroupIdValue(tenantGroupCompanyCode, cod);
                tenantGroup.add(cod);
            }
        }

    }

    public List<String> getIdsByPIdPub(String tenantGroupCompanyCode, String tenantGroupCode) {
        List<GroupDto> ocpTenantGroups = ocpTenantGroupMapper.tenantBaseTreeOther(tenantGroupCode, tenantGroupCompanyCode);
        return ocpTenantGroups.stream().map(OcpTenantGroup::getTenantGroupCode).collect(Collectors.toList());
    }

}
