import '@fortawesome/fontawesome-free/css/all.css'
import 'material-design-icons-iconfont/dist/material-design-icons.css'



import Vue from 'vue'

import Vuex from 'vuex';
Vue.use(Vuex);
import store from '@/store';

import VueResource from 'vue-resource';
Vue.use(VueResource);

import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css';
Vue.use(ElementUI);

import App from './App'
import router from './router'


// cookies
import VueCookies from 'vue-cookies'
Vue.use(VueCookies)

import mavonEditor from 'mavon-editor'
Vue.use(mavonEditor)
import 'mavon-editor/dist/css/index.css'

import "@/services/routeblocking";

Vue.config.productionTip = false

import Echarts from "echarts"
Vue.prototype.$chart = Echarts
import ECharts from 'vue-echarts/components/ECharts'
Vue.component('chart', ECharts)




// i18n
import VueI18n from 'vue-i18n'
Vue.use(VueI18n) // 通过插件的形式挂载

const i18n = new VueI18n({
  locale: 'zh', // 语言标识 //this.$i18n.locale // 通过切换locale的值来实现语言切换
  messages: {
    'zh': require('./i18n/language-zh'),  //引入language-zh.js  language-en,js
    'en': require('./i18n/language-en')
  }
})

// 超级打印
import Print from 'vue-print-nb'
Vue.use(Print);

Vue.prototype.echartsResize = (ref) =>
{
  window.onresize = function ()
  {
    for (var i = 0; i < ref.length; i++) {
      ref[i].resize()
    }
  }
};

import api from '@/request/api.js'
Vue.prototype.$api = api;

new Vue({
  router,
  store,
  i18n,
  render: h => h(App)
}).$mount("#app")
