import axios from '@/request/http'; // 导入http中创建的axios实例
import services from "@/services";
import qs from 'qs'; // 根据需求是否导入qs模块


const event = {
    // 新增事件
    dialogSubmitjs(data) {
        return axios.post(`${services.event}/add`, data);
    },

    // 事件详情
    detailInfo(urlParams, user) {
        if (user == 3 || user == 4) {
            return axios.get(`/sjgl/api/village/events/detail?event_id=${urlParams.event_id}`);
        } else {
            return axios.get(`${services.event}/detail?event_id=${urlParams.event_id}`);

        }
    },
    //事件编辑详情提交
    editDetailSubmit(data, user) {
        if (user == 1) {
            return axios.post(`${services.event}/update/event/waitaccept`, data);
        } else if (user == 2) {
            return axios.post(`${services.event}/update/event/waitdispatch`, data);
        } else if (user == 3) {
            return axios.post(`/sjgl/api/village/events/update/event/waitaccept`, data);
        } else if (user == 4) {
            return axios.post(`/sjgl/api/village/events/update/event/waitdispatch`, data);
        }
    },
    //撤销,受理
    dialogSubmitRevoke(urlParams, data) {
        console.log(urlParams)
        if (urlParams.nextstep == '撤销') {
            console.log('撤销')
            return axios.post(`${services.event}/cancel`, data);
        } else if (urlParams.nextstep == '受理' && urlParams.behavior <= 1 && urlParams.type == '转派遣') {
            console.log('受理---市')
            return axios.post(`${services.event}/accept`, data);
        } else if (urlParams.nextstep == '受理' && urlParams.type == '退回') {
            console.log('退回')
            return axios.post(`/sjgl/api/events/back/village`, data);
        } else if (urlParams.nextstep == '受理' && urlParams.type == '转派遣' && (urlParams.behavior == 2 || urlParams.behavior == 3 || urlParams.behavior == 4)) {
            console.log('转派遣----乡')
            return axios.post(`/sjgl/api/village/events/accept`, data);
        } else if (urlParams.nextstep == '受理' && urlParams.type == '申请退回' && urlParams.behavior == 2) {
            console.log('申请退回')
            return axios.post(`/sjgl/api/village/events/back/accepttocounty`, data);
        } else if (urlParams.nextstep == '受理' && urlParams.behavior == 5) {
            console.log('同意自办自结')
            return axios.post(`/sjgl/api/village/events/selfcase/accept`, data);
        } else if (urlParams.nextstep == '拒绝') {
            console.log('拒绝')
            return axios.post(`/sjgl/api/village/events/refuse`, data);
        }
    },
    //派遣，退回
    dialogSubmitDispatch(urlParams, data) {
        console.log(data)
        console.log(urlParams)
        if (urlParams.type == '派遣' && urlParams.user == 2 && urlParams.nextstep == '派遣') {
            // console.log('市-派遣')
            return axios.post(`${services.event}/dispatch`, data);
        } else if (urlParams.nextstep == '退回' && urlParams.user == 2) {
            // console.log('市-退回')
            return axios.post(`${services.event}/back/accepts`, data);
        } else if (urlParams.type == '转乡镇受理' && urlParams.user == 2) {
            // console.log('市-转乡镇受理')
            return axios.post(`${services.event}/tovillageaccept`, data);
        } else if (urlParams.type == '派遣' && urlParams.user == 4 && urlParams.nextstep == '派遣') {
            // console.log('乡-派遣')
            return axios.post(`/sjgl/api/village/events/dispatch`, data);
        } else if (urlParams.nextstep == '派遣' && urlParams.type == '转市级受理' && urlParams.user == 4) {
            // console.log('乡-转市级受理')
            return axios.post(`/sjgl/api/village/events/dispatchto/county`, data);
        } else if (urlParams.nextstep == '退回' && urlParams.user == 4) {
            // console.log('乡-退回')
            return axios.post(`/sjgl/api/village/events/back/accepts`, data);
        }
    },
    //结案审核
    dialogSubmitToclose(urlParams, data) {
        if (urlParams.type == '结案' && urlParams.user == 1) {
            console.log('市-结案')
            return axios.post(`${services.event}/finish`, data);
        } else if (urlParams.type == '返工' && urlParams.user == 1) {
            console.log('市-返工')
            return axios.post(`${services.event}/back/dispatchs`, data);
        } else if (urlParams.type == '结案' && urlParams.user == 3) {
            console.log('乡-结案')
            return axios.post(`/sjgl/api/village/events/finish`, data);
        } else if (urlParams.type == '返工' && urlParams.user == 3) {
            console.log('乡-返工')
            return axios.post(`/sjgl/api/village/events/back/dispatchs`, data);
        }
    },

    //审核
    dialogSubmitCheck(urlParams, data) {
        if (urlParams.type == '同意') {
            return axios.post(`${services.event}/toaudit/pass`, data);
        } else {
            return axios.post(`${services.event}/toaudit/refuse`, data);
        }
    },


    // 地图拾点
    mapGetPoint(keywords) {
        return axios.get(`https://restapi.amap.com/v3/place/text?keywords=${keywords}&city=320481&citylimit=true&output=json&offset=20&page=1&key=966cdd04fb6b722679bc24c5d630f04d`);
    },
    // 选择辖区列表
    codeInfo() {
        return axios.get(`${services.event}/area/listall`);
    },
    // 坐标点获取该点网格id
    xyToGrid(x, y) {
        return axios.get(`${services.gis}/xyToGrid?x=${x}&y=${y}`);
    },
    // 选择事件类型
    eventTypeInfo() {
        return axios.get(`/system/api/eventtypes/tree`);
    },
    // 立案条件-编辑页面
    eventTypeInfo_latj(urlParams) {
        return axios.get(`/system/api/eventtypes/latj?cate_id=${urlParams.cate_id}`);
    },
    // 处置时限-编辑页面
    eventTypeInfo_czsj(urlParams) {
        return axios.get(`/system/api/eventtypes/czsx?latj_id=${urlParams.latj_id}`);
    },
    // 选择处置人
    handleuserInfo() {
        return axios.get(`/system/api/department/list?limit=0`);
    },
    // 选择场所类型
    placeTypeInfo() {
        return axios.get(`/system/api/eventtypes/tree`);
    },
}

export default event;