

class TsdkClient
{
    constructor()
    {

        this.createTsdkClient();
        this.ecUserName = "0519779";
        this.isbookConference = false;
    };

    createTsdkClient ()
    {
        var that = this;
        var tsdkJsInitParam = {
            invokeMode: 1,
            svrAddr: "localhost.cloudec.huaweicloud.com",
            svrPort: "7684",
            ssl: 1
        };
        this.isNoLogin = false;
        var listeners = {
            OnEvtAuthSuccess: (ret) =>
            {
                console.debug('auth success!');
                console.log("auth success!" + JSON.stringify(ret))
            },
            OnEvtLoginSuccess: (ret) =>
            {
                console.info('login success!' + JSON.stringify(ret));
                that.isNoLogin = true;
                console.log("login success!")
            },
            OnEvtAuthFailed: (ret) =>
            {
                that.isNoLogin = false;
                console.log(ret);
                console.log("OnEvtAuthFailed!")
            },
            OnEvtLogoutSuccess: (ret) =>
            {
                console.log("logout Sucesss!")
            },
            OnEvtLogoutFailed: (ret) =>
            {
                console.log('logout failed!')
            },

            OnEvtCallIncoming: (ret) =>
            {
                that.callInComingId = ret.param.callId
                console.log("Please answer" + JSON.stringify(ret))
                if (that.isbookConference) {
                    that.confId = ret.param.confId;
                    that.acceptCall(ret.param.callInfo.callId, ret.param.callInfo.isVideoCall);
                    that.requestChairman();
                }
            },
            OnEvtOpenVideoReq: (ret) =>
            {
                console.log("Audio to video")
            },
            OnEvtCloseVideoInd: (ret) =>
            {
                console.log("video to audio")
            },
            OnEvtOpenVideoInd: (ret) =>
            {
                console.log("video to audio")
            },
            OnEvtRefuseOpenVideoInd: (ret) =>
            {
                console.log("rejected!!!")
            },

            OnEvtBookConfResult: (ret) =>
            {
                console.log("book join successs" + JSON.stringify(ret))
            },
            OnEvtQueryConfListResult: (ret) =>
            {
                that.consfList = ret
            },
            OnEvtJoinConfResult: (ret) =>
            {
                console.log("join sunccess" + JSON.stringify(ret))
                that.handle = ret.param.handle
            },
            OnEvtQueryConfListResult: (ret) =>
            {
                that.callbackDatas = ret
            },
            OnError: function (ret)
            {
                if (390000003 == ret.info.errorCode) {
                    console.warn("Memory usage over 80%, please close the unrelated program.");
                } else {
                    console.log(JSON.stringify(ret));
                }
            },
            /***************************************************监听事件*****************************************************/
            OnEvtCallOutgoing: (ret) =>//发送呼叫
            {
                console.log("呼叫信息发送成功!")
                that.callId = ret.param.callId
                if (that.OnCallOutgoing) {
                    that.OnCallOutgoing(ret);
                }

                console.log(ret)
            },
            OnEvtCallEnded: (ret) =>//呼叫挂断
            {
                console.log("通话连接挂断成功!")
                that.callId = "";
                if (that.OnCallEnded) {
                    that.OnCallEnded(ret);
                }

                console.log(ret)
            },
            OnEvtUiPluginClickHangupCall: (ret) =>//UI插件触发挂断呼叫事件
            {
                console.log("UI插件挂断呼叫!")
                that.callId = ret.param.callId;
                console.log(ret)
                that.endCall();
                //that.callId = "";
            },
            OnEvtUiPluginClickLeaveConf: (ret) =>//UI插件触发离开会议事件
            {
                console.log("UI插件离开会议!")
                //that.callId = ret.param.callId;
                console.log(ret)
                that.endCall();
                //that.callId = "";
            },
            OnEvtUiPluginClickEndConf: (ret) =>//UI插件触发结束会议事件
            {
                console.log("UI插件结束会议!")
                //that.callId = ret.param.callId;
                console.log(ret)
                that.endCall();
                //that.callId = "";
            },
            OnEvtCallConnected: (ret) =>//通话连接成功
            {
                console.log("通话连接建立!")
                that.callId = ret.param.callId;
                if (that.OnCallConnected) {
                    that.OnCallConnected(ret);
                }

                console.log(ret)
            },
            OnEvtUiPluginClickMuteMic: (ret) =>//UI插件触发闭音麦克风
            {
                console.log("UI插件闭音麦克风!")
                console.log(ret)
                that.tsdkClient.muteMic(ret.param.callId, !ret.param.micBtnStateInfo.isMute, function (data)
                {
                    console.log("--进入muteMic的回调--")
                    console.log(data);
                })
            },
            OnEvtUiPluginClickMuteSpeaker: (ret) =>//UI插件触发闭音扬声器
            {
                console.log("UI插件闭音扬声器!")
                console.log(ret)
                that.tsdkClient.muteSpeaker(ret.param.callId, !ret.param.speakerBtnStateInfo.isMute, function (data)
                {
                    console.log("--进入muteMic的回调--")
                    console.log(data);
                })
            },
            OnEvtUiPluginClickMuteCamera: (ret) =>//UI插件触发闭音摄像头
            {
                console.log("UI插件闭音摄像头!")
                console.log(ret)
                if (!ret.param.cameraBtnStateInfo.isMute) {
                    that.tsdkClient.delVideo(ret.param.callId, function (data)
                    {
                        console.log("--进入muteMic的回调--")
                        console.log(data);
                    })
                } else {
                    that.tsdkClient.addVideo(ret.param.callId, function (data)
                    {
                        console.log("--进入muteMic的回调--")
                        console.log(data);
                    })
                }

            },
        };
        this.tsdkClient = terminalSDK.createTsdkClient(tsdkJsInitParam, listeners);
        if (this.tsdkClient == null) {
            console.log("createTsdkClient失败");
        }
    }
    LoginTSDK (user_id)
    {
        var that = this;
        if (user_id == "admin") {
            this.ecUserName = "0519780";
        }
        console.log("当前登录设备:" + this.ecUserName);
        setTimeout(() =>
        {
            console.log("--进入setTimeout--")
            that.setConfigParam();
        }, 3000);

    }
    setConfigParam ()
    {
        var that = this;
        var configParam = {
            logParam: 1,
            tlsParam: 1,
            proxyParam: 1,
            serviceSecurityParam: 1,
            iptServiceConfigParam: 1,
            localAddress: 1,
            filePathInfo: 1,
            dpiInfo: 1,
            networkInfo: 1,
            ipCallSwitch: 0,
            confCtrlParam: 1,
            sendDataSwitch: 1,
            baseInfoParam: 1,
            frameParam: 1,
            visibleInfo: 1
        }
        console.log("--进入setConfigParam--")
        var callback = function (ret)
        {
            console.log("setConfigParam_callback");
            console.log(ret)
            that.init();
        }
        this.tsdkClient.setConfigParam(configParam, callback);
        console.log("--setConfigParam执行完毕--")
    }
    init ()
    {
        var that = this;
        var tsdkAppInfoParam = {
            "clientType": 0,
            "productName": "SoftClient on Desktop",
            "deviceSn": "1",
            "supportAudioAndVideoCall": 1,
            "supportAudioAndVideoConf": 1,
            "supportDataConf": 1,
            "supportCtd": 0,
            "supportIm": 0,
            "supportRichMediaMessage": 0,
            "supportEnterpriseAddressBook": 0,
            "useUiPlugin": 1,
            "isWsInvokeMode": 1,
        };
        var callbacks = function (res) { }
        this.tsdkClient.init(tsdkAppInfoParam, (res) =>
        {
            console.log("init_callback");
            console.log(res)
            if (res.result == 0) {
                console.log("init success!")
            }
            that.login();
        });
    }
    login ()
    {
        var that = this;
        console.log(this.isNoLogin)
        var tsdkLoginParam = {
            "userId": 1,
            "authType": 0,
            "userName": this.ecUserName,//SC上分配的预定义节点
            "password": "huawei123",
            "userTiket": "1",
            "serverType": 2,//SMC服务器
            "serverVersion": "",
            "serverAddr": "2.49.137.84",//SMC服务器地址
            "serverPort": 5060  // 5061
        };
        var callbacks = function (res)
        {
            console.log("login_callback");
            console.log(res)
        }
        console.debug('login begin');
        console.log(tsdkLoginParam)
        this.tsdkClient.login(tsdkLoginParam, callbacks);

        // console.debug('login ret:' + callbacks);
        // passwd = "";
        // proxyPassword = "";
        // proxyParam = "";

        // document.getElementById("call").style.display = "block";
    }
    //开始呼叫（呼叫的号码，是否视频呼叫）
    startCall (calleeNum, isVideoCall)
    {
        console.log("--进入startCall--")
        this.tsdkClient.startCall(calleeNum, isVideoCall, function (data)
        {
            //call_Id = data.param.callId
            console.log("--进入startCall的回调--")
            console.log(data);
            if (data.result) {

            }
        });
    }
    //结束呼叫
    endCall ()
    {
        var that = this;
        this.tsdkClient.endCall(this.callId, function (data)
        {
            console.log("结束通话");
            console.log(data);
            that.callId = "";
        });
    }
    //加入会议（会议id，是否视频会议）
    acceptCall (callId, isVideoCall)
    {
        console.log("--acceptCall--")
        this.callId = callId;
        this.tsdkClient.acceptCall(callId, isVideoCall, function (data)
        {
            //call_Id = data.param.callId
            console.log("--进入acceptCall的回调--")
            console.log(data);
            if (data.result) {

            }
        });
    }
    //创建会议
    bookConference (users)
    {

        var attendeeList = [];
        attendeeList.push({
            displayName: "管理员",
            number: this.ecUserName,
            role: 0,
            sms: "",
            email: ""
        })
        users.forEach(function (item)
        {
            var attendeeParam = {}
            attendeeParam.displayName = item.userName
            attendeeParam.number = item.equipCode
            attendeeParam.role = 0
            attendeeParam.smsPhone = ""
            attendeeParam.email = ""
            attendeeList.push(attendeeParam)
        })
        var bookConfInfo = {
            welcomePrompt: 2,//入会提示音类型
            isMultiStreamConf: 0,//是否为多流视频会议，预留
            language: 1,//会议的默认语言
            isHdConf: 1,//是否高清视频会议
            isAutoMute: 1,//非主席在入会后是否自动闭音
            attendeeNum: 2,//与会者数量
            confType: 0,//会议类型
            recordMode: 0,//会议媒体录制模式
            isAutoRecord: 0,//会议是否自动启动录制，预留
            enterPrompt: 1,//有成员入会提示音类型
            groupUri: "",//群组uri
            attendeeList: attendeeList,//与会者列表
            startTime: null,//会议开始时间，格式：YYYY-MM-DD HH:MM，立即会议时无需填写
            confEncryptMode: 0,//会议媒体加密模式
            duration: 60,//120分钟
            confMediaType: 1,//视频
            reminder: 0,//会议提醒方式
            size: 2,//会议方数
            leavePrompt: 0,//有成员离会提示音类型
            isAutoProlong: 1,//是否自动延长会议
            subject: "多人视频会议",//会议主题
        }
        console.log("发起会议");
        console.log(bookConfInfo);
        var that = this;
        this.tsdkClient.bookConference(bookConfInfo, function (ret)
        {
            that.isbookConference = true;
            console.log("bookConference callback" + JSON.stringify(ret))
        })
    }
    //结束会议
    endConference ()
    {
        var that = this;
        this.tsdkClient.endConference(this.confId, function (ret)
        {

            console.log("endConference callback" + JSON.stringify(ret))
        })
    }
    //申请主席
    requestChairman ()
    {
        var that = this;
        this.tsdkClient.requestChairman(this.confId, "", function (ret)
        {
            console.log("requestChairman callback" + JSON.stringify(ret))
        })
    }
}
export default TsdkClient;
