import axios from '@/request/http'; // 导入http中创建的axios实例
import services from "@/services";
import qs from 'qs'; // 根据需求是否导入qs模块


const common = {

    tablePagination(urlParams) {
        return axios.get(`${urlParams.url}`,{
            params:urlParams.params
        });
    },
    getNowMenu(params) {
        return axios.get(`/apaas/backmgt/menu/user/menu?teamName=${params.teamName}`);
    },
    deleteFile(params) {
        return axios.delete(`/bgfile/bg/delete?url=${params.file_path}`);
    },
    logout(params) {
        return axios.get(`/bgiam/api/logout?ReturnUrl=${params.return_url}`)
    },
    getNowUser() {
        return axios.get(`/bgiam/api/getCurUser`);
    },
    headersave(data) {
        return axios.post(`/sjgl/api/events/setlistview`,data);
    },
    getheaders(params) {
        return axios.get(`/sjgl/api/events/getlistviewsetting?name=${params.name}`);
    },
        //菜单管理
    getMenuList(){
        return axios.get(`${services.systemapi}/menu/tree`);
    },
    //当前用户菜单
    getUserMenuList(){
        return axios.get(`/system/api/menu/userMenu`);
    },
}

export default common;