import axios from '@/request/http'; // 导入http中创建的axios实例
import services from "@/services";


const contact = {
    // 获取列表
    contactList (data)
    {
        //?page=1&limit=5&search=
        return axios.get(`/jczl/app/rest/equip/list?page=${data.page}&limit=${data.limit}&search=${data.search ? data.search : ''}`);
    },
    equipmentInfo (equipmentId)
    {
        return axios.get(`/jczl/app/rest/equip/object/${equipmentId}`);
    },
    groupList (data)
    {
        return axios.get(`/jczl/app/rest/group/groupList?page=${data.page}&limit=${data.limit}&name=${data.search ? data.search : ''}`);
    },
    addGroup (data)
    {
        return axios.post(`/jczl/app/rest/group/addGroup`, data);
    },
    delGroup (id)
    {
        return axios.get(`/jczl/app/rest/group/delGroup?id=` + id);
    }
}

export default contact;