import axios from '@/request/http'; // 导入http中创建的axios实例
import services from "@/services";
import qs from 'qs'; // 根据需求是否导入qs模块


const system = {
    //菜单管理
    getMenuList(){
        return axios.get(`${services.systemapi}/menu/tree`);
    },
    getMenu(query){
        return axios.get(`${services.systemapi}/menu/object/${query.id}`);
    },
    addMenu(data){
        return axios.post(`${services.systemapi}/menu`,data);
    },
    editMenu(query,data){
        return axios.put(`${services.systemapi}/menu/object/${query.id}`,data);
    },
    delMenu(query){
        return axios.delete(`${services.systemapi}/menu/object/${query.id}`);
    },
    positionMenu(params){
        return axios.post(`${services.systemapi}/menu/order`,params);
    },

    // 事件类型管理
    getEventTypeList(payload) {
        return axios.get("/system/api/eventtypes/list", payload);
    },
    deleteEventTypeList(payload) {
        return axios.post("/system/api/eventtypes/batchdel", payload);
    },
    updaterEventTypeList(payload) {
        return axios.post("/system/api/eventtypes/update", payload);
    },
    getEventTypeDetail(payload) {
        return axios.get("/system/api/eventtypes/detail", payload);
    },

    // 选择今日排班，明日排班
    planersInfo() {
        return axios.get(`/system/api/user/list?limit=0`);
    },
}

export default system;